package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

//import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

public class CODER implements Serializable, IModel {
//    private static final long serialVersionUID = -316102112618444130L;

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CODER.class);

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型参数
     */
    private ParamsDo paramsDo;


    private Map<String, Map<Integer, Integer>> coderMap;

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;

    /**
     * 特征
     */
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(FBT_MAX_SIZE);
    ;

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }


    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }


    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }


    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Integer, Integer>> getCoderMap() {
        return coderMap;
    }

    public void setCoderMap(Map<String, Map<Integer, Integer>> coderMap) {
        this.coderMap = coderMap;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public String getCode(Map<String, String> featureMap) throws Exception {
        String ret = null;


        try {

            CodeResult codeResult = FeatureCoder.codeOfEachField(getFeatureBaseType(), featureMap);

            Map<String, Map<Integer, Double>> fieldFeatureMap = codeResult.getFieldFeatureMap();

//            List<List<Integer>> coderList=FeatureNewCoder.codeOfEachFieldWithSeq();

            List<String> fieldStringList = new ArrayList<>();
            for (FeatureBaseType featureBaseType : featureBaseType) {


                String field = featureBaseType.getName();

                List<Integer> fCode = new ArrayList<>();

                Map<Integer, Double> sparceCode = fieldFeatureMap.get(field);
                Map<Integer, Integer> denseCodeMap = coderMap.get(field);
                List<Integer> sparceCodeKeyList = new ArrayList<>(sparceCode.keySet());

                Integer filedDefaultValue = denseCodeMap.getOrDefault(0, 0);

                for (int i = 0; i < sparceCodeKeyList.size(); i++) {
                    Integer codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                    fCode.add(codeDense);
                }


                // 输出：特征拼接
                String fCodeString = CollectionUtil.toString(fCode, ",");

                // 输出：域拼接
                String fieldString = field + ":" + fCodeString;

                fieldStringList.add(fieldString);


            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, ";");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public String getCode2(Map<String, String> featureMap) throws Exception {
        String ret = null;

        try {
            Map<String, List<Integer>> codeMap = FeatureNewCoder.codeOfEachFieldWithSeqForOne(getFeatureBaseType(), featureMap);
            ret = getCodeWithSeq(codeMap);
//            System.out.println("getCode2=" + JSON.toJSONString(ret));
        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }


//    /**
//     * @param featureMap
//     * @return
//     * @throws Exception
//     */
//    public String getCode(FeatureMapDo featureMap) throws Exception {
//        String ret = null;
//
//
//        try {
//
//            CodeResult codeResult = FeatureCoder.codeOfEachField(getFeatureBaseType(), featureMap);
//
//            Map<String, Map<Integer, Double>> fieldFeatureMap = codeResult.getFieldFeatureMap();
//
//
//            List<String> fieldStringList = new ArrayList<>();
//            for (FeatureBaseType featureBaseType : featureBaseType) {
//
//
//                String field = featureBaseType.getName();
//
//                List<Integer> fCode = new ArrayList<>();
//
//                Map<Integer, Double> sparceCode = fieldFeatureMap.get(field);
//                Map<Integer, Integer> denseCodeMap = coderMap.get(field);
//                List<Integer> sparceCodeKeyList = new ArrayList<>(sparceCode.keySet());
//
//                Integer filedDefaultValue = denseCodeMap.getOrDefault(0, 0);
//
//                for (int i = 0; i < sparceCodeKeyList.size(); i++) {
//                    Integer codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
//                    fCode.add(codeDense);
//                }
//
//
//                // 输出：特征拼接
//                String fCodeString = CollectionUtil.toString(fCode, ",");
//
//                // 输出：域拼接
//                String fieldString = field + ":" + fCodeString;
//
//                fieldStringList.add(fieldString);
//
//
//            }
//
//            // 输出：样本拼接
//            ret = CollectionUtil.toString(fieldStringList, ";");
//
//        } catch (Exception e) {
//            logger.warn("getCode is invalid ", e);
//        }
//
//
//        return ret;
//    }

    /**
     * @param codeResult
     * @return
     * @throws Exception
     */
    public String getCode(CodeResult codeResult) throws Exception {
        String ret = null;

        try {

            Map<String, Map<Integer, Double>> fieldFeatureMap = codeResult.getFieldFeatureMap();


//            System.out.println("getCode=" + JSON.toJSONString(fieldFeatureMap));

            List<String> fieldStringList = new ArrayList<>();
            for (FeatureBaseType featureBaseType : featureBaseType) {


                String field = featureBaseType.getName();

                List<Integer> fCode = new ArrayList<>();

                Map<Integer, Double> sparceCode = fieldFeatureMap.get(field);
                Map<Integer, Integer> denseCodeMap = coderMap.get(field);
                List<Integer> sparceCodeKeyList = new ArrayList<>(sparceCode.keySet());

                Integer filedDefaultValue = denseCodeMap.getOrDefault(0, 0);

                for (int i = 0; i < sparceCodeKeyList.size(); i++) {
                    Integer codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                    fCode.add(codeDense);
                }


                // 输出：特征拼接
                String fCodeString = CollectionUtil.toString(fCode, ",");

                // 输出：域拼接
                String fieldString = field + ":" + fCodeString;

                fieldStringList.add(fieldString);


            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, ";");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }

    /**
     * @param codeMap
     * @return
     * @throws Exception
     */
    public String getCodeWithSeq(Map<String, List<Integer>> codeMap) throws Exception {
        String ret = null;

        try {
//            System.out.println("getCode s=" + JSON.toJSONString(codeMap));

            List<String> fieldStringList = new ArrayList<>();
            for (FeatureBaseType featureBaseType : featureBaseType) {

                String field = featureBaseType.getName();

                List<Integer> fCode = new ArrayList<>();

                List<Integer> sparceCodeKeyList = codeMap.get(field);

                Integer filedDefaultValue = coderMap.get(field).getOrDefault(0, 0);
                for (int i = 0; i < sparceCodeKeyList.size(); i++) {

                    Integer codeDense = coderMap.get(field).getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                    fCode.add(codeDense);
                }


                // 输出：特征拼接
                String fCodeString = CollectionUtil.toString(fCode, ",");

                // 输出：域拼接
                String fieldString = field + ":" + fCodeString;

                fieldStringList.add(fieldString);


            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, ";");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), predict(entry.getValue()));
            }
        }

        return ret;
    }

    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), predict(entry.getValue()));
            }
        }

        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, List<Float>> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;

    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodes(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), getCode(entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }

        return ret;

    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodesNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureMap)) {
            Map<T, CodeResult> codeResultMap = FeatureNewCoder.codeOfEachField(getFeatureBaseType(), featureMap);

//            Map<T, List<List<Integer>>> codeMap = FeatureNewCoder.codeOfEachFieldWithSeq(getFeatureBaseType(), featureMap);

            for (Map.Entry<T, CodeResult> entry : codeResultMap.entrySet()) {
                ret.put(entry.getKey(), getCode(entry.getValue()));
            }

        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }
//        System.out.println("getCodesNew=" + JSON.toJSONString(ret));
        return ret;

    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodesNewWithSeq(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureMap)) {
            Map<T, Map<String, List<Integer>>> codeMap = FeatureNewCoder.codeOfEachFieldWithSeq(getFeatureBaseType(), featureMap);

            for (Map.Entry<T, Map<String, List<Integer>>> entry : codeMap.entrySet()) {
                ret.put(entry.getKey(), getCodeWithSeq(entry.getValue()));
            }

        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }

//        System.out.println("getCodesNewWithSeq=" + JSON.toJSONString(ret));
        return ret;

    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || (featureMap != null && featureMap.size() > 70)) {

            ret = null;
        } else {

            try {

//                System.out.println(JSON.toJSONString(getCodes(featureMap)));

                ret = tfServingClient.predictString(getCodes(featureMap));
//                System.out.println("dd="+JSON.toJSONString(ret));
            } catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }


        }


        return ret;
    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || (featureMap != null && featureMap.size() > 70)) {

            ret = null;
        } else {

            try {

//                System.out.println(JSON.toJSONString(getCodes(featureMap)));

                ret = tfServingClient.predictString(getCodesNew(featureMap));
//                System.out.println("dd="+JSON.toJSONString(ret));
            } catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }


        }


        return ret;
    }


    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
//            DBTimeProfile.enter("CODER.predictWithLocalTF");
            if (AssertUtil.isNotEmpty(featureMap)) {
//                getCodes(featureMap);
//                System.out.println(JSON.toJSONString(getCodes(featureMap)));
//                System.out.println(JSON.toJSONString(featureMap));

                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                Map<T, String> fMap = getCodes(featureMap);

//                System.out.println("o p="+ JSON.toJSONString(fMap));
                if (AssertUtil.isEmpty(fMap)) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);

//                System.out.println(JSON.toJSONString(ret));
            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predicts(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }

    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
//            DBTimeProfile.enter("CODER.predictWithLocalTF");
            if (AssertUtil.isNotEmpty(featureMap)) {
//                getCodes(featureMap);
//                System.out.println(JSON.toJSONString(getCodes(featureMap)));
//                System.out.println(JSON.toJSONString(featureMap));

                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                Map<T, String> fMap = getCodesNew(featureMap);
//                System.out.println("n f="+JSON.toJSONString(fMap));
                if (AssertUtil.isEmpty(fMap)) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);

//                System.out.println(JSON.toJSONString(ret));
            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }


    public static void main(String[] args) {

        CODER coder = new CODER();

        Map<String, Map<Integer, Integer>> map = new HashMap<>();

        Map<Integer, Integer> map1 = new HashMap<>();
        map1.put(0, 999);
        map1.put(101, 1001);
        map1.put(102, 1002);
        map1.put(103, 1003);
        map1.put(104, 1004);
        map1.put(105, 1005);

        map.put("f1001", map1);
        Map<Integer, Integer> map2 = new HashMap<>();
        map2.put(0, 999);
        map2.put(200, 2000);
        map2.put(202, 2002);
        map2.put(203, 2003);
        map2.put(204, 2004);
        map.put("f1002", map2);


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(10);
        featureBaseType2.setName("f1002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);

        coder.setCoderMap(map);
        coder.setFeatureBaseType(list);

        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f1001", "100,104,102,103");
        featureMap.put("f1002", "202");


        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);

        try {
            coder.getCodesNew(featureMapDoMap);
            coder.getCodesNewWithSeq(featureMapDoMap);
            coder.getCode2(featureMap);

        } catch (Exception e) {

        }

    }

}
