package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DCVR implements Serializable {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DCVR.class);
    private int PB_MAX_SIZE = 128;

    /**
     * 后端预估模型
     */
    private IModel dCvrModel;

    public IModel getDCvrModel() {
        return dCvrModel;
    }

    public void setDCvrModel(IModel bCvrModel) {
        this.dCvrModel = dCvrModel;
    }

    /**
     * @param dctrModel
     */
    public DCVR(IModel dcvrModel) {
        this.dCvrModel = dcvrModel;
    }

    /**
     * 预估主接口
     *
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<PredictResultType, Map<T, Double>> predictDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = new HashMap<>(PB_MAX_SIZE);

        Map<T, Double> dcvrMap = dCvrModel.predictsNew(featureMap);

        if (AssertUtil.isAllNotEmpty(dcvrMap)) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            ret = null;
        }

        return ret;
    }
}