/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder;
import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.CodeResult;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CODER
implements Serializable,
IModel {
    private static final Logger logger = LoggerFactory.getLogger(CODER.class);
    private String modelId;
    private String updateTime;
    private ParamsDo paramsDo;
    private Map<String, Map<Integer, Integer>> coderMap;
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(this.FBT_MAX_SIZE);

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Integer, Integer>> getCoderMap() {
        return this.coderMap;
    }

    public void setCoderMap(Map<String, Map<Integer, Integer>> coderMap) {
        this.coderMap = coderMap;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        return ret;
    }

    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;
        return ret;
    }

    public String getCode(Map<String, String> featureMap) throws Exception {
        String ret = null;
        try {
            CodeResult codeResult = FeatureCoder.codeOfEachField(this.getFeatureBaseType(), featureMap);
            Map fieldFeatureMap = codeResult.getFieldFeatureMap();
            ArrayList<String> fieldStringList = new ArrayList<String>();
            for (FeatureBaseType featureBaseType : this.featureBaseType) {
                String field = featureBaseType.getName();
                ArrayList<Integer> fCode = new ArrayList<Integer>();
                Map sparceCode = (Map)fieldFeatureMap.get(field);
                Map<Integer, Integer> denseCodeMap = this.coderMap.get(field);
                ArrayList sparceCodeKeyList = new ArrayList(sparceCode.keySet());
                Integer filedDefaultValue = denseCodeMap.getOrDefault(0, 0);
                for (int i = 0; i < sparceCodeKeyList.size(); ++i) {
                    Integer codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                    fCode.add(codeDense);
                }
                String fCodeString = CollectionUtil.toString(fCode, ",");
                String fieldString = field + ":" + fCodeString;
                fieldStringList.add(fieldString);
            }
            ret = CollectionUtil.toString(fieldStringList, ";");
        }
        catch (Exception e) {
            logger.warn("getCode is invalid ", (Throwable)e);
        }
        return ret;
    }

    public String getCode2(Map<String, String> featureMap) throws Exception {
        String ret = null;
        try {
            Map codeMap = FeatureNewCoder.codeOfEachFieldWithSeqForOne(this.getFeatureBaseType(), featureMap);
            ret = this.getCodeWithSeq(codeMap);
        }
        catch (Exception e) {
            logger.warn("getCode is invalid ", (Throwable)e);
        }
        return ret;
    }

    public String getCode(CodeResult codeResult) throws Exception {
        String ret = null;
        try {
            Map fieldFeatureMap = codeResult.getFieldFeatureMap();
            ArrayList<String> fieldStringList = new ArrayList<String>();
            for (FeatureBaseType featureBaseType : this.featureBaseType) {
                String field = featureBaseType.getName();
                ArrayList<Integer> fCode = new ArrayList<Integer>();
                Map sparceCode = (Map)fieldFeatureMap.get(field);
                Map<Integer, Integer> denseCodeMap = this.coderMap.get(field);
                ArrayList sparceCodeKeyList = new ArrayList(sparceCode.keySet());
                Integer filedDefaultValue = denseCodeMap.getOrDefault(0, 0);
                for (int i = 0; i < sparceCodeKeyList.size(); ++i) {
                    Integer codeDense = denseCodeMap.getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                    fCode.add(codeDense);
                }
                String fCodeString = CollectionUtil.toString(fCode, ",");
                String fieldString = field + ":" + fCodeString;
                fieldStringList.add(fieldString);
            }
            ret = CollectionUtil.toString(fieldStringList, ";");
        }
        catch (Exception e) {
            logger.warn("getCode is invalid ", (Throwable)e);
        }
        return ret;
    }

    public String getCodeWithSeq(Map<String, List<Integer>> codeMap) throws Exception {
        String ret = null;
        try {
            ArrayList<String> fieldStringList = new ArrayList<String>();
            for (FeatureBaseType featureBaseType : this.featureBaseType) {
                String field = featureBaseType.getName();
                ArrayList<Integer> fCode = new ArrayList<Integer>();
                List<Integer> sparceCodeKeyList = codeMap.get(field);
                Integer filedDefaultValue = this.coderMap.get(field).getOrDefault(0, 0);
                for (int i = 0; i < sparceCodeKeyList.size(); ++i) {
                    Integer codeDense = this.coderMap.get(field).getOrDefault(sparceCodeKeyList.get(i), filedDefaultValue);
                    fCode.add(codeDense);
                }
                String fCodeString = CollectionUtil.toString(fCode, ",");
                String fieldString = field + ":" + fCodeString;
                fieldStringList.add(fieldString);
            }
            ret = CollectionUtil.toString(fieldStringList, ";");
        }
        catch (Exception e) {
            logger.warn("getCode is invalid ", (Throwable)e);
        }
        return ret;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.predict(entry.getValue()));
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<T, Double> ret = new HashMap<T, Double>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.predict(entry.getValue()));
            }
        }
        return ret;
    }

    public <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        return ret;
    }

    public <T> Map<T, String> getCodes(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, String> ret = new HashMap<T, String>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                ret.put(entry.getKey(), this.getCode(entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    public <T> Map<T, String> getCodesNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            Map codeResultMap = FeatureNewCoder.codeOfEachField(this.getFeatureBaseType(), featureMap);
            for (Map.Entry entry : codeResultMap.entrySet()) {
                ret.put(entry.getKey(), this.getCode((CodeResult)entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    public <T> Map<T, String> getCodesNewWithSeq(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            Map codeMap = FeatureNewCoder.codeOfEachFieldWithSeq(this.getFeatureBaseType(), featureMap);
            for (Map.Entry entry : codeMap.entrySet()) {
                ret.put(entry.getKey(), this.getCodeWithSeq((Map)entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || featureMap != null && featureMap.size() > 70) {
            ret = null;
        } else {
            try {
                ret = tfServingClient.predictString(this.getCodes(featureMap));
            }
            catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null || featureMap != null && featureMap.size() > 70) {
            ret = null;
        } else {
            try {
                ret = tfServingClient.predictString(this.getCodesNew(featureMap));
            }
            catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        try {
            if (AssertUtil.isNotEmpty(featureMap)) {
                Map<T, String> fMap;
                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                if (AssertUtil.isEmpty(fMap = this.getCodes(featureMap))) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);
            }
        }
        catch (Exception e) {
            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, (Throwable)e);
            ret = this.predicts(featureMap);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        try {
            if (AssertUtil.isNotEmpty(featureMap)) {
                Map<T, String> fMap;
                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                if (AssertUtil.isEmpty(fMap = this.getCodesNew(featureMap))) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);
            }
        }
        catch (Exception e) {
            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, (Throwable)e);
            ret = this.predictsNew(featureMap);
        }
        return ret;
    }

    public static void main(String[] args) {
        CODER coder = new CODER();
        HashMap<String, Map<Integer, Integer>> map = new HashMap<String, Map<Integer, Integer>>();
        HashMap<Integer, Integer> map1 = new HashMap<Integer, Integer>();
        map1.put(0, 999);
        map1.put(101, 1001);
        map1.put(102, 1002);
        map1.put(103, 1003);
        map1.put(104, 1004);
        map1.put(105, 1005);
        map.put("f1001", map1);
        HashMap<Integer, Integer> map2 = new HashMap<Integer, Integer>();
        map2.put(0, 999);
        map2.put(200, 2000);
        map2.put(202, 2002);
        map2.put(203, 2003);
        map2.put(204, 2004);
        map.put("f1002", map2);
        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");
        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(10);
        featureBaseType2.setName("f1002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(100000);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");
        List<FeatureBaseType> list = Arrays.asList(featureBaseType1, featureBaseType2);
        coder.setCoderMap(map);
        coder.setFeatureBaseType(list);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f1001", "100,104,102,103");
        featureMap.put("f1002", "202");
        HashMap<String, FeatureMapDo> featureMapDoMap = new HashMap<String, FeatureMapDo>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);
        try {
            coder.getCodesNew(featureMapDoMap);
            coder.getCodesNewWithSeq(featureMapDoMap);
            coder.getCode2(featureMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

