/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCVR
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DCVR.class);
    private int PB_MAX_SIZE = 128;
    private IModel dCvrModel;
    private IModel coderModel;
    private LocalTFModel dcvrLocalTFModel;
    private TFServingClient dcvrServingClient;

    public IModel getDCvrModel() {
        return this.dCvrModel;
    }

    public void setDCvrModel(IModel bCvrModel) {
        this.dCvrModel = this.dCvrModel;
    }

    public TFServingClient getDcvrServingClient() {
        return this.dcvrServingClient;
    }

    public void setDcvrServingClient(TFServingClient dcvrServingClient) {
        this.dcvrServingClient = dcvrServingClient;
    }

    public DCVR(IModel dcvrModel) {
        this.dCvrModel = dcvrModel;
    }

    public DCVR(IModel dCvrModel, IModel coderModel, TFServingClient dcvrServingClient) {
        this.dCvrModel = dCvrModel;
        this.coderModel = coderModel;
        this.dcvrServingClient = dcvrServingClient;
    }

    public DCVR(IModel dCvrModel, IModel coderModel, LocalTFModel dcvrLocalTFModel) {
        this.dCvrModel = dCvrModel;
        this.coderModel = coderModel;
        this.dcvrLocalTFModel = dcvrLocalTFModel;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFNew(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            return this.predictDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            return this.predictDCvrWithLocalTF(featureMap);
        }
        return this.predictDCvr(featureMap);
    }
}

