package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import cn.com.duiba.nezha.alg.feature.coder.FeatureNewCoder2;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.Feature;
import cn.com.duiba.nezha.alg.feature.vo.Feature2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

//import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;

public class CODER2 implements Serializable, IModel {
//    private static final long serialVersionUID = -316102112618444130L;

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(CODER2.class);

    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型参数
     */
    private ParamsDo paramsDo;


    private Map<String, Map<Integer, Integer>> coderMap;

    private Map<String, Map<String, Feature2>> tmpCoderCache = new ConcurrentHashMap<>();
    private Map<String, Map<String, String>> tmpCoderStrCache = new ConcurrentHashMap<>();

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;

    /**
     * 特征
     */
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(FBT_MAX_SIZE);
    ;

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }


    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getModelId() {
        return this.modelId;
    }


    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }


    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Integer, Integer>> getCoderMap() {
        return coderMap;
    }

    public void setCoderMap(Map<String, Map<Integer, Integer>> coderMap) {
        this.coderMap = coderMap;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;

        return ret;
    }
//

    /**
     * 单个请求
     * @param codeMap
     * @return
     * @throws Exception
     */
    public String getCode(Map<String, String> codeMap) throws Exception {

        Map<String, Feature2> retMap = FeatureNewCoder2.codeOfEachFieldWithSeq(getFeatureBaseType(), codeMap, null, tmpCoderCache);
        return getCodeWithSeq(retMap);
    }


    /**
     * @param codeMap
     * @return
     * @throws Exception
     */
    public String getCodeWithSeq(Map<String, Feature2> codeMap) throws Exception {
        String ret = null;

        try {

            List<String> fieldStringList = new ArrayList<>();

            for (FeatureBaseType featureBaseType : featureBaseType) {

                String fieldName = featureBaseType.getName();

                int fieldType = featureBaseType.getCodeType();

                Feature2 sparceCode = codeMap.get(fieldName);

                String featureValue = sparceCode.featureStr;

                String fCodeString = null;

                if (tmpCoderStrCache.get(fieldName) == null) {
                    tmpCoderStrCache.put(fieldName, new ConcurrentHashMap<>());
                }

                if (tmpCoderStrCache.get(fieldName).get(featureValue) == null) {

                    String tmpfCodeString = getCoderString(sparceCode, fieldName, fieldType);
                    tmpCoderStrCache.get(fieldName).put(featureValue, tmpfCodeString);
                }

                fCodeString = tmpCoderStrCache.get(fieldName).get(featureValue);

                // 输出：域拼接
                String fieldString = fieldName + ":" + fCodeString;

                fieldStringList.add(fieldString);


            }

            // 输出：样本拼接
            ret = CollectionUtil.toString(fieldStringList, ";");

        } catch (Exception e) {
            logger.warn("getCode is invalid ", e);
        }


        return ret;
    }

    /**
     * @return
     */
    public String getCoderString(Feature2 sparceCode, String fieldName, int fieldType) throws Exception {
        String fCodeString = null;

        if (fieldType != 41) {
            List<Integer> fCodeId = new ArrayList<>();
            Integer filedDefaultValue = coderMap.get(fieldName).getOrDefault(0, 0);
            // 非embedding特征
            for (int i = 0; i < sparceCode.indices.length; i++) {

                Integer codeDense = coderMap.get(fieldName).getOrDefault(sparceCode.indices[i], filedDefaultValue);
                fCodeId.add(codeDense);

            }

            // 输出：特征拼接
            fCodeString = CollectionUtil.toString(fCodeId, ",");

        } else {
            // 输出：特征拼接
            fCodeString = CollectionUtil.toString(sparceCode.values, ",");
        }

        return fCodeString;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;
    }

    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, Double> ret = new HashMap<>(PB_MAX_SIZE);

        return ret;
    }


    /**
     * @param featureMap
     * @return
     * @throws Exception
     */
    public <T> Map<T, String> getCodesNewWithSeq(Map<T, FeatureMapDo> featureMap) throws Exception {
        Map<T, String> ret = new HashMap<>(PB_MAX_SIZE);


        if (AssertUtil.isNotEmpty(featureMap)) {
            Map<T, Map<String, Feature2>> codeMap = FeatureNewCoder2.codeOfEachFieldWithSeq(getFeatureBaseType(), featureMap, tmpCoderCache);


            for (Map.Entry<T, Map<String, Feature2>> entry : codeMap.entrySet()) {
                ret.put(entry.getKey(), getCodeWithSeq(entry.getValue()));
            }

        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }

//        System.out.println("getCodesNewWithSeq=" + JSON.toJSONString(ret));
        return ret;

    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * @param featureMap
     * @param tfServingClient
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        if (tfServingClient == null) {

            ret = null;
        } else {
            try {
                ret = tfServingClient.predictString(getCodesNewWithSeq(featureMap));
//                System.out.println("dd="+JSON.toJSONString(ret));
            } catch (Exception e) {
                e.printStackTrace();
                String logInfo = tfServingClient.modelName + " predictWithTF warn ";
                logger.warn(logInfo + e);
                ret = null;
            }


        }


        return ret;
    }


    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;


        return ret;
    }

    /**
     * @param featureMap
     * @param localTFModel
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
//            DBTimeProfile.enter("CODER.predictWithLocalTF");
            if (AssertUtil.isNotEmpty(featureMap)) {


                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                Map<T, String> fMap = getCodesNewWithSeq(featureMap);
//                System.out.println("n f="+JSON.toJSONString(fMap));
                if (AssertUtil.isEmpty(fMap)) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(fMap);

            }
        } catch (Exception e) {

            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }


    public static void main(String[] args) {

        CODER2 coder = new CODER2();

        Map<String, Map<Integer, Integer>> map = new HashMap<>();

        Map<Integer, Integer> map1 = new HashMap<>();
        map1.put(0, 999);
        map1.put(101, 1001);
        map1.put(102, 1002);
        map1.put(103, 1003);
        map1.put(104, 1004);
        map1.put(105, 1005);

        map.put("f1001", map1);
        Map<Integer, Integer> map2 = new HashMap<>();
        map2.put(0, 999);
        map2.put(1, 2000);
        map2.put(2, 2002);
        map2.put(3, 2003);
        map2.put(4, 2004);
        map.put("f1002", map2);


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(41);
        featureBaseType2.setName("f1002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(4);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1);

        coder.setCoderMap(map);
        coder.setFeatureBaseType(list);

        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f1001", "100,104");
        featureMap.put("f1002", "0.9,1.0,1.1,1.34");


        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);

        try {
//            coder.getCodesNew(featureMapDoMap);
            System.out.println(JSON.toJSONString(coder.getCodesNewWithSeq(featureMapDoMap)));
            featureMap.put("f1001", "100,104,105");
            System.out.println(JSON.toJSONString(coder.getCodesNewWithSeq(featureMapDoMap)));
//            coder.getCode2(featureMap);

        } catch (Exception e) {

            System.out.println(e);
        }

    }

}
