/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepModelV2;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCVRv2
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DCVRv2.class);
    private IModel dCvrModel;
    private DeepModelV2 coderModel;
    private LocalTFModelV2 dcvrLocalTFModel;
    private TFServingClient dcvrServingClient;

    public LocalTFModelV2 getDcvrLocalTFModel() {
        return this.dcvrLocalTFModel;
    }

    public void setDcvrLocalTFModel(LocalTFModelV2 dcvrLocalTFModel) {
        this.dcvrLocalTFModel = dcvrLocalTFModel;
    }

    public IModel getDCvrModel() {
        return this.dCvrModel;
    }

    public void setDCvrModel(IModel dCvrModel) {
        this.dCvrModel = dCvrModel;
    }

    public TFServingClient getDcvrServingClient() {
        return this.dcvrServingClient;
    }

    public void setDcvrServingClient(TFServingClient dcvrServingClient) {
        this.dcvrServingClient = dcvrServingClient;
    }

    public DCVRv2(IModel dcvrModel) {
        this.dCvrModel = dcvrModel;
    }

    public DCVRv2(IModel dCvrModel, DeepModelV2 coderModel, TFServingClient dcvrServingClient) {
        this.dCvrModel = dCvrModel;
        this.coderModel = coderModel;
        this.dcvrServingClient = dcvrServingClient;
    }

    public DCVRv2(IModel dCvrModel, DeepModelV2 coderModel, LocalTFModelV2 dcvrLocalTFModel) {
        this.dCvrModel = dCvrModel;
        this.coderModel = coderModel;
        this.dcvrLocalTFModel = dcvrLocalTFModel;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvr(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.dCvrModel.predictsNew(featureMap);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrWithTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithTFNew(featureMap, this.dcvrServingClient);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": dcvr fusing");
            dcvrMap = this.dCvrModel.predictsNew(featureMap);
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrWithLocalTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>();
        Map<T, Double> dcvrMap = this.coderModel.predictWithLocalTFV2(featureMap, this.dcvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
            ret.put(PredictResultType.DCVR, dcvrMap);
        } else {
            logger.warn(this.coderModel.getModelId() + ": dcvr fusing");
            if (this.dCvrModel != null) {
                dcvrMap = this.dCvrModel.predictsNew(featureMap);
            }
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{dcvrMap})) {
                ret.put(PredictResultType.DCVR, dcvrMap);
            } else {
                ret = null;
            }
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictDCvrAndTF(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (this.dcvrServingClient != null) {
            return this.predictDCvrWithTF(featureMap);
        }
        if (this.dcvrLocalTFModel != null) {
            return this.predictDCvrWithLocalTF(featureMap);
        }
        return this.predictDCvr(featureMap);
    }

    public static void main(String[] args) {
        String coderRedisUtil = "default";
        String coderId = "ad_dcvr_delay_v01";
    }
}

