/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.coder.FeatureCoder3;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.vo.FeatureCode;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.ParamsDo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DenseCoder
implements Serializable,
IModel {
    private static final Logger logger = LoggerFactory.getLogger(DenseCoder.class);
    private String modelId;
    private String updateTime;
    private ParamsDo paramsDo;
    private Map<String, Map<Integer, Integer>> coderMap;
    private Map<String, Map<String, FeatureCode>> tmpCoderCache = new HashMap<String, Map<String, FeatureCode>>();
    private Map<String, Map<String, String>> tmpCoderStrCache = new HashMap<String, Map<String, String>>();
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    private List<FeatureBaseType> featureBaseType = new ArrayList<FeatureBaseType>(this.FBT_MAX_SIZE);

    public void setFeatureBaseType(List<FeatureBaseType> featureBaseType) {
        this.featureBaseType = featureBaseType;
    }

    public List<FeatureBaseType> getFeatureBaseType() {
        return this.featureBaseType;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setParamsDo(ParamsDo paramsDo) {
        this.paramsDo = paramsDo;
    }

    public ParamsDo getParamsDo() {
        return this.paramsDo;
    }

    public Map<String, Map<Integer, Integer>> getCoderMap() {
        return this.coderMap;
    }

    public void setCoderMap(Map<String, Map<Integer, Integer>> coderMap) {
        this.coderMap = coderMap;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        Double ret = null;
        return ret;
    }

    public Double predict(FeatureMapDo featureMap) throws Exception {
        Double ret = null;
        return ret;
    }

    public String getCode(Map<String, String> codeMap) throws Exception {
        Map retMap = FeatureCoder3.codeOfEachFieldWithSeq(this.getFeatureBaseType(), codeMap, null, this.tmpCoderCache);
        return this.getDenseCode(retMap);
    }

    public String getDenseCode(Map<String, FeatureCode> codeMap) throws Exception {
        String ret = null;
        try {
            ArrayList<String> fieldStringList = new ArrayList<String>();
            for (FeatureBaseType featureBaseType : this.featureBaseType) {
                String fieldName = featureBaseType.getName();
                int fieldType = featureBaseType.getCodeType();
                FeatureCode featureCode = codeMap.get(fieldName);
                String featureValue = featureCode.featureStr;
                String fCodeString = null;
                if (this.tmpCoderStrCache.get(fieldName) == null) {
                    this.tmpCoderStrCache.put(fieldName, new HashMap());
                }
                if (this.tmpCoderStrCache.get(fieldName).get(featureValue) == null) {
                    String tmpfCodeString = this.getDenseCoderStr(featureCode, fieldName, fieldType);
                    this.tmpCoderStrCache.get(fieldName).put(featureValue, tmpfCodeString);
                }
                fCodeString = this.tmpCoderStrCache.get(fieldName).get(featureValue);
                String fieldString = fieldName + ":" + fCodeString;
                fieldStringList.add(fieldString);
            }
            ret = CollectionUtil.toString(fieldStringList, ";");
        }
        catch (Exception e) {
            logger.warn("getCode is invalid ", (Throwable)e);
        }
        return ret;
    }

    public String getDenseCoderStr(FeatureCode featureCode, String fieldName, int fieldType) throws Exception {
        String fCodeString = null;
        if (fieldType != 41) {
            ArrayList<Integer> fCodeId = new ArrayList<Integer>();
            for (int i = 0; i < featureCode.indices.length; ++i) {
                Integer codeDense = this.coderMap.get(fieldName).getOrDefault(featureCode.indices[i], 0);
                fCodeId.add(codeDense);
            }
            fCodeString = CollectionUtil.toString(fCodeId, ",");
        } else {
            fCodeString = CollectionUtil.toString(featureCode.values, ",");
        }
        return fCodeString;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap ret = new HashMap(this.PB_MAX_SIZE);
        return ret;
    }

    public <T> Map<T, String> getDenseCodes(Map<T, Map<String, FeatureCode>> featureCodeMap) throws Exception {
        HashMap<T, String> ret = new HashMap<T, String>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureCodeMap)) {
            for (Map.Entry<T, Map<String, FeatureCode>> entry : featureCodeMap.entrySet()) {
                ret.put(entry.getKey(), this.getDenseCode(entry.getValue()));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn("getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        try {
            if (AssertUtil.isNotEmpty(featureMap)) {
                Map featureCodeMap;
                Map<T, String> denseCoderMap;
                if (localTFModel == null) {
                    logger.info("predictWithLocalTF,local model is null");
                }
                if (AssertUtil.isEmpty(denseCoderMap = this.getDenseCodes(featureCodeMap = FeatureCoder3.codeOfEachFieldWithSeq(this.getFeatureBaseType(), featureMap, this.tmpCoderCache)))) {
                    logger.info("predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictStr(denseCoderMap);
            }
        }
        catch (Exception e) {
            String logInfo = "predictWithTF warn ";
            logger.info(logInfo, (Throwable)e);
            ret = this.predictsNew(featureMap);
        }
        return ret;
    }

    public static void main(String[] args) {
        DenseCoder coder = new DenseCoder();
        HashMap<String, Map<Integer, Integer>> map = new HashMap<String, Map<Integer, Integer>>();
        HashMap<Integer, Integer> map1 = new HashMap<Integer, Integer>();
        map1.put(0, 999);
        map1.put(101, 1001);
        map1.put(102, 1002);
        map1.put(103, 1003);
        map1.put(104, 1004);
        map1.put(105, 1005);
        map.put("f1001", map1);
        HashMap<Integer, Integer> map2 = new HashMap<Integer, Integer>();
        map2.put(0, 999);
        map2.put(1, 2000);
        map2.put(2, 2002);
        map2.put(3, 2003);
        map2.put(4, 2004);
        map.put("f1002", map2);
        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");
        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(41);
        featureBaseType2.setName("f1002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(4);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");
        List<FeatureBaseType> list = Arrays.asList(featureBaseType1);
        coder.setCoderMap(map);
        coder.setFeatureBaseType(list);
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f1001", "100,104");
        featureMap.put("f1002", "0.9,1.0,1.1,1.34");
        HashMap<String, FeatureMapDo> featureMapDoMap = new HashMap<String, FeatureMapDo>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);
    }
}

