/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.DeepBaseModelV2;
import cn.com.duiba.nezha.alg.model.DeepModel;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import cn.com.duiba.nezha.alg.model.vo.CodeSizeDo;
import cn.com.duiba.nezha.alg.model.vo.ModelMetaData;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepModelV2
extends DeepBaseModelV2
implements Serializable,
IModel {
    private static final Logger logger = LoggerFactory.getLogger(DeepModelV2.class);
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    public static Map<String, Integer> tmpIntMap = new HashMap<String, Integer>();
    public static Map tmpMap = new HashMap();
    private String modelId;
    private String updateTime;
    private ModelMetaData modelMeta;
    private List<FeatureBaseType2> featureList = new ArrayList<FeatureBaseType2>();
    private CodeSizeDo codeSizeDo = null;
    private Map<String, Map<String, Integer>> featureDenseCoderMap = new HashMap<String, Map<String, Integer>>();

    public <T> Map<T, CodeDo> getPredDenseCodes(Map<T, FeatureMapDo> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, boolean hasSubCache, boolean hasMultValueCache) throws Exception {
        return this.getPredDenseCodes(featureMaps, coderCache, this.modelId, hasSubCache, hasMultValueCache, this.featureList, this.featureDenseCoderMap);
    }

    public CodeSizeDo getCodeSize() throws Exception {
        if (this.codeSizeDo == null) {
            this.codeSizeDo = this.getCodeSize(this.featureList);
        }
        return this.codeSizeDo;
    }

    public <T> Map<T, CodeDo> getSampleDenses(Map<T, Map<String, String>> featureMaps, Map<String, Map<String, List<Integer>>> coderCache) throws Exception {
        return this.getSampleDenses(featureMaps, coderCache, this.modelId, this.featureList, this.featureDenseCoderMap);
    }

    public CodeDo getSampleDense(Map<String, String> featureMap, Map<String, Map<String, List<Integer>>> coderCache) throws Exception {
        return this.getSampleDense(featureMap, coderCache, this.modelId, this.featureList, this.featureDenseCoderMap);
    }

    public static String toString(CodeDo codeDo) throws Exception {
        String ret = "";
        if (AssertUtil.isNotEmpty(codeDo.getSingleCode())) {
            String sCode = CollectionUtil.toString(codeDo.getSingleCode(), ",");
            ret = ret + ":" + sCode;
        }
        if (AssertUtil.isNotEmpty(codeDo.getMultiCode())) {
            String mCode = CollectionUtil.toString(codeDo.getMultiCode(), ";");
            ret = ret + ":" + mCode;
        }
        if (AssertUtil.isNotEmpty(codeDo.getFloatCode())) {
            String fCode = CollectionUtil.toString(codeDo.getFloatCode(), ",");
            ret = ret + ":" + fCode;
        }
        return ret;
    }

    public void printInfo() throws Exception {
        this.printInfo(this.featureList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Map<T, Double> predictWithLocalTFV2(Map<T, FeatureMapDo> featureMap, LocalTFModelV2 localTFModel) throws Exception {
        Map<T, Double> ret = null;
        try {
            if (AssertUtil.isNotEmpty(featureMap)) {
                if (localTFModel == null) {
                    logger.info(this.modelId + " predictWithLocalTF,local model is null");
                }
                Map<T, CodeDo> featureCodeMap = this.getPredDenseCodes(featureMap, null, false, false);
                CodeSizeDo codeSizeDo = this.getCodeSizeDo();
                if (AssertUtil.isEmpty(featureCodeMap)) {
                    logger.info(this.modelId + " predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictAll(featureCodeMap, codeSizeDo);
            }
        }
        catch (Exception e) {
            logger.info(this.modelId + " predictWithTF warn ", (Throwable)e);
            ret = this.predictsNew(featureMap);
        }
        return ret;
    }

    @Override
    public Double predict(Map<String, String> featureMap) throws Exception {
        return null;
    }

    @Override
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        return null;
    }

    @Override
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        return null;
    }

    @Override
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    @Override
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;
        return ret;
    }

    public static void main(String[] args) {
        DeepModelV2 coder = new DeepModelV2();
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Integer> map1 = new HashMap<String, Integer>();
        map1.put("0", 999);
        map1.put("101", 1001);
        map1.put("102", 1002);
        map1.put("103", 1003);
        map1.put("104", 1004);
        map1.put("105", 1005);
        map.put("f1001", map1);
        HashMap<String, Integer> map2 = new HashMap<String, Integer>();
        map2.put("0", 999);
        map2.put("1", 2000);
        map2.put("2", 2002);
        map2.put("3", 2003);
        map2.put("4", 2004);
        map.put("f1002", map2);
        FeatureBaseType2 featureBaseType1 = new FeatureBaseType2();
        featureBaseType1.setCodeType(Integer.valueOf(1));
        featureBaseType1.setFeatureId("f1001");
        featureBaseType1.setDenseLen(Integer.valueOf(10000));
        featureBaseType1.setSubLen(1);
        featureBaseType1.setSplitChar(",");
        FeatureBaseType2 featureBaseType2 = new FeatureBaseType2();
        featureBaseType2.setCodeType(Integer.valueOf(2));
        featureBaseType2.setFeatureId("f1002");
        featureBaseType2.setDenseLen(Integer.valueOf(1000));
        featureBaseType2.setSubLen(4);
        featureBaseType2.setSplitChar(",");
        FeatureBaseType2 featureBaseType3 = new FeatureBaseType2();
        featureBaseType3.setCodeType(Integer.valueOf(3));
        featureBaseType3.setFeatureId("f1003");
        featureBaseType3.setDenseLen(Integer.valueOf(2));
        featureBaseType3.setSubLen(4);
        featureBaseType3.setSplitChar(",");
        List<FeatureBaseType2> list = Arrays.asList(featureBaseType1, featureBaseType1, featureBaseType2, featureBaseType2, featureBaseType3);
        coder.setFeatureDenseCoderMap(map);
        coder.setFeatureList(list);
        String coderStr = JSON.toJSONString((Object)coder);
        DeepModel coder1 = (DeepModel)JSON.parseObject((String)coderStr, DeepModel.class);
        System.out.println(coderStr);
        System.out.println(JSON.toJSONString((Object)coder1));
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put("f1001", "104");
        featureMap.put("f10011", "104");
        featureMap.put("f1003", "0.1");
        HashMap<String, FeatureMapDo> featureMapDoMap = new HashMap<String, FeatureMapDo>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);
        try {
            Map ret = coder.getPredDenseCodes(featureMapDoMap, null, false, false);
            System.out.println(JSON.toJSONString(ret));
            System.out.println(DeepModelV2.toString(ret.get("s1")));
            coder.printInfo();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeepModelV2)) {
            return false;
        }
        DeepModelV2 other = (DeepModelV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getFBT_MAX_SIZE() != other.getFBT_MAX_SIZE()) {
            return false;
        }
        if (this.getPB_MAX_SIZE() != other.getPB_MAX_SIZE()) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        ModelMetaData this$modelMeta = this.getModelMeta();
        ModelMetaData other$modelMeta = other.getModelMeta();
        if (this$modelMeta == null ? other$modelMeta != null : !((Object)this$modelMeta).equals(other$modelMeta)) {
            return false;
        }
        List<FeatureBaseType2> this$featureList = this.getFeatureList();
        List<FeatureBaseType2> other$featureList = other.getFeatureList();
        if (this$featureList == null ? other$featureList != null : !((Object)this$featureList).equals(other$featureList)) {
            return false;
        }
        CodeSizeDo this$codeSizeDo = this.getCodeSizeDo();
        CodeSizeDo other$codeSizeDo = other.getCodeSizeDo();
        if (this$codeSizeDo == null ? other$codeSizeDo != null : !((Object)this$codeSizeDo).equals(other$codeSizeDo)) {
            return false;
        }
        Map<String, Map<String, Integer>> this$featureDenseCoderMap = this.getFeatureDenseCoderMap();
        Map<String, Map<String, Integer>> other$featureDenseCoderMap = other.getFeatureDenseCoderMap();
        return !(this$featureDenseCoderMap == null ? other$featureDenseCoderMap != null : !((Object)this$featureDenseCoderMap).equals(other$featureDenseCoderMap));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeepModelV2;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getFBT_MAX_SIZE();
        result = result * 59 + this.getPB_MAX_SIZE();
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        ModelMetaData $modelMeta = this.getModelMeta();
        result = result * 59 + ($modelMeta == null ? 43 : ((Object)$modelMeta).hashCode());
        List<FeatureBaseType2> $featureList = this.getFeatureList();
        result = result * 59 + ($featureList == null ? 43 : ((Object)$featureList).hashCode());
        CodeSizeDo $codeSizeDo = this.getCodeSizeDo();
        result = result * 59 + ($codeSizeDo == null ? 43 : ((Object)$codeSizeDo).hashCode());
        Map<String, Map<String, Integer>> $featureDenseCoderMap = this.getFeatureDenseCoderMap();
        result = result * 59 + ($featureDenseCoderMap == null ? 43 : ((Object)$featureDenseCoderMap).hashCode());
        return result;
    }

    @Override
    public int getFBT_MAX_SIZE() {
        return this.FBT_MAX_SIZE;
    }

    @Override
    public int getPB_MAX_SIZE() {
        return this.PB_MAX_SIZE;
    }

    @Override
    public String getModelId() {
        return this.modelId;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public ModelMetaData getModelMeta() {
        return this.modelMeta;
    }

    public List<FeatureBaseType2> getFeatureList() {
        return this.featureList;
    }

    public CodeSizeDo getCodeSizeDo() {
        return this.codeSizeDo;
    }

    public Map<String, Map<String, Integer>> getFeatureDenseCoderMap() {
        return this.featureDenseCoderMap;
    }

    @Override
    public void setFBT_MAX_SIZE(int FBT_MAX_SIZE) {
        this.FBT_MAX_SIZE = FBT_MAX_SIZE;
    }

    @Override
    public void setPB_MAX_SIZE(int PB_MAX_SIZE) {
        this.PB_MAX_SIZE = PB_MAX_SIZE;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public void setModelMeta(ModelMetaData modelMeta) {
        this.modelMeta = modelMeta;
    }

    public void setFeatureList(List<FeatureBaseType2> featureList) {
        this.featureList = featureList;
    }

    public void setCodeSizeDo(CodeSizeDo codeSizeDo) {
        this.codeSizeDo = codeSizeDo;
    }

    public void setFeatureDenseCoderMap(Map<String, Map<String, Integer>> featureDenseCoderMap) {
        this.featureDenseCoderMap = featureDenseCoderMap;
    }

    @Override
    public String toString() {
        return "DeepModelV2(FBT_MAX_SIZE=" + this.getFBT_MAX_SIZE() + ", PB_MAX_SIZE=" + this.getPB_MAX_SIZE() + ", modelId=" + this.getModelId() + ", updateTime=" + this.getUpdateTime() + ", modelMeta=" + this.getModelMeta() + ", featureList=" + this.getFeatureList() + ", codeSizeDo=" + this.getCodeSizeDo() + ", featureDenseCoderMap=" + this.getFeatureDenseCoderMap() + ")";
    }
}

