/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model.util;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.DataType;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Tensor;
import org.tensorflow.Tensors;
import org.tensorflow.framework.TensorInfo;

public class OneTFUtils {
    private static final Logger logger = LoggerFactory.getLogger(OneTFUtils.class);

    public static SavedModelBundle loadModel(String modelPath, String version) {
        String path = Paths.get(modelPath, version).toString();
        logger.info("local model path =" + path);
        SavedModelBundle bundle = SavedModelBundle.load((String)path, (String[])new String[]{"serve"});
        return bundle;
    }

    public static Long getLastVersion(String path) throws Exception {
        Long ret = null;
        File file = new File(path);
        if (file.isDirectory()) {
            File[] listFiles = file.listFiles();
            for (int i = 0; i < Objects.requireNonNull(listFiles).length; ++i) {
                File f = listFiles[i];
                String fName = f.getName();
                if (!StringUtils.isNumeric((String)fName)) continue;
                long version = Long.parseLong(fName);
                if (ret != null && ret >= version) continue;
                ret = version;
            }
        }
        return ret;
    }

    public static Tensor<?> listToTensor(List<String> input, TensorInfo inputInfo) {
        org.tensorflow.framework.DataType dtype = inputInfo.getDtype();
        int inputSize = input.size();
        if (dtype == org.tensorflow.framework.DataType.DT_FLOAT) {
            float[] arrayInput = new float[inputSize];
            for (int i = 0; i < input.size(); ++i) {
                String s = input.get(i);
                float inputWithType = 0.0f;
                if (s != null) {
                    try {
                        inputWithType = Float.parseFloat(s);
                    }
                    catch (NumberFormatException e) {
                        logger.warn("listToTensor exception", (Throwable)e);
                    }
                }
                arrayInput[i] = inputWithType;
            }
            return Tensors.create((float[])arrayInput);
        }
        if (dtype == org.tensorflow.framework.DataType.DT_STRING) {
            byte[][] arrayInput = new byte[inputSize][];
            for (int i = 0; i < input.size(); ++i) {
                String s = input.get(i);
                String inputWithType = "";
                if (s != null) {
                    inputWithType = s;
                }
                arrayInput[i] = inputWithType.getBytes(StandardCharsets.UTF_8);
            }
            return Tensors.create((byte[][])arrayInput);
        }
        return null;
    }

    public static float[][] tensorToArray(Tensor<?> tensorResult) {
        long[] tensorShape = tensorResult.shape();
        if (DataType.FLOAT == tensorResult.dataType()) {
            float[][] listResult = new float[(int)tensorShape[0]][(int)tensorShape[1]];
            tensorResult.copyTo((Object)listResult);
            return listResult;
        }
        return null;
    }

    public static void closeQuitely(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T extends AutoCloseable> void closeQuitely(Collection<T> closeables) {
        if (CollectionUtils.isNotEmpty(closeables)) {
            for (AutoCloseable closeable : closeables) {
                OneTFUtils.closeQuitely(closeable);
            }
        }
    }
}

