/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.TimeUnit;

public class GrpcClientSingle {
    private String host;
    private int port;
    private ManagedChannel channel;

    public GrpcClientSingle(String host, int port) {
        this.setChannel(host, port);
    }

    public void shutdown() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
    }

    public ManagedChannel getChannel() {
        this.validateChannel();
        return this.channel;
    }

    public void setChannel(String host, int port) {
        this.host = host;
        this.port = port;
        this.setChannel();
    }

    public synchronized void validateChannel() {
        if (this.channel.isShutdown() || this.channel.isTerminated()) {
            this.setChannel();
        }
    }

    public synchronized void setChannel() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().build();
    }
}

