package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import cn.com.duiba.nezha.alg.model.vo.CodeSizeDo;
import cn.com.duiba.nezha.alg.model.vo.ModelMetaData;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.collections.MapUtils;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

/**
 * 单编码器版本
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DeepModelV2 extends DeepBaseModelV2 implements Serializable, IModel {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DeepModelV2.class);

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;
    public static Map<String, Integer> tmpIntMap = new HashMap<>();
    public static Map tmpMap = new HashMap<>();
    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型元数据集合
     * Map<模型ID, 模型元数据对象>
     */
    private ModelMetaData modelMeta;

    /**
     * 特征元数据集合
     * Map<特征ID, 特征元数据对象>
     */
    private List<FeatureBaseType2> featureList = new ArrayList<>();

    private CodeSizeDo codeSizeDo = null;

    /**
     * 特征编码集合
     * Map<特征ID, 特征Meta对象>
     */
    private Map<String, Map<String, Integer>> featureDenseCoderMap = new HashMap<>();


    /**
     * 模型预估环节，获取稠密编码
     *
     * @param featureMaps       特征对象
     * @param coderCache        全局缓存对象
     * @param hasSubCache       是否开启请求级别缓存
     * @param hasMultValueCache 多值特征是否开启缓存
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, CodeDo> getPredDenseCodes(Map<T, FeatureMapDo> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, boolean hasSubCache, boolean hasMultValueCache) throws Exception {

        return getPredDenseCodes(featureMaps,
                coderCache,
                modelId,
                hasSubCache,
                hasMultValueCache,
                featureList,
                featureDenseCoderMap);

    }

    public <T> Map<T, CodeDo> getPredDenseCodes(Map<T, FeatureMapDo> featureMaps, String coderVersion) throws Exception {

        return getPredDenseCodes(featureMaps,
                modelId,
                coderVersion,
                featureList,
                featureDenseCoderMap);
    }

    public CodeSizeDo getCodeSize() throws Exception {
        if (codeSizeDo == null) {
            codeSizeDo = getCodeSize(featureList);
        }
        return codeSizeDo;
    }

    /**
     * 样本生成环节，获取稠密编码
     * <p>
     * 单值特征：动态编码=起始位置+稠密编码
     * 多值特征：静态编码=稠密编码，多余位过滤
     * 浮点特征：静态编码=原值映射，不足位补0f
     *
     * @param featureMaps
     * @param coderCache
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, CodeDo> getSampleDenses(Map<T, Map<String, String>> featureMaps, Map<String, Map<String, List<Integer>>> coderCache) throws Exception {

        return getSampleDenses(featureMaps,
                coderCache,
                modelId,
                featureList,
                featureDenseCoderMap);

    }

    /**
     * 样本生成环节，获取稠密编码
     *
     * @param featureMap
     * @param coderCache
     * @return
     * @throws Exception
     */
    public CodeDo getSampleDense(Map<String, String> featureMap, Map<String, Map<String, List<Integer>>> coderCache) throws Exception {

        return getSampleDense(featureMap,
                coderCache,
                modelId,
                featureList,
                featureDenseCoderMap);
    }

    /**
     * 编码拼接说明
     * 1、编码包含三个部分：单值编码、多值编码、浮点编码
     * 2、不同类型编码，使用":"符号分割。示例：单值编码:多值编码:浮点编码
     * 3、单值特征编码，使用","符号分割。示例：特征1_值,特征2_值,特征3_值
     * 4、多值特征编码，使用";"、","符号分割。示例：特征1-值1,特征1-值2;特征2-值1,特征2-值2
     * 5、浮点特征编码，使用";"、","符号分割。示例：特征1-值1,特征1-值2,特征2-值1,特征2-值2
     * <p>
     * 完整样本示例：单值特征1,单值特征2:多值特征3_值1,多值特征3_值2;多值特征4_值1,多值特征4_值2:浮点特征5_值1,浮点特征5_值2,浮点特征6_值1,浮点特征6_值2
     *
     * @param codeDo
     * @return
     * @throws Exception
     */
    public static String toString(CodeDo codeDo) throws Exception {
        String ret = "";
        // 单值特征编码
        if (AssertUtil.isNotEmpty(codeDo.getSingleCode())) {
            String sCode = CollectionUtil.toString(codeDo.getSingleCode(), ",");
            ret = ret + ":" + sCode;
        }
        // 多值特征编码
        if (AssertUtil.isNotEmpty(codeDo.getMultiCode())) {
            String mCode = CollectionUtil.toString(codeDo.getMultiCode(), ";");
            ret = ret + ":" + mCode;
        }
        // 浮点特征编码
        if (AssertUtil.isNotEmpty(codeDo.getFloatCode())) {
            String fCode = CollectionUtil.toString(codeDo.getFloatCode(), ",");
            ret = ret + ":" + fCode;
        }

        return ret;
    }

    public void printInfo() throws Exception {
        printInfo(featureList);

    }


    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFV2(Map<T, FeatureMapDo> featureMap, LocalTFModelV2 localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
            if (AssertUtil.isNotEmpty(featureMap)) {


                if (localTFModel == null) {
                    logger.info(modelId + " predictWithLocalTF,local model is null");
                }

                /**
                 * 获取特征编码
                 */
                //Map<T, CodeDo> featureCodeMap = getPredDenseCodes(featureMap, null, false, false);
                Map<T, CodeDo> featureCodeMap = getPredDenseCodes(featureMap, localTFModel.getVersion());
                CodeSizeDo codeSizeDo = getCodeSize();

                if (AssertUtil.isEmpty(featureCodeMap)) {
                    logger.info(modelId + " predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictAll(featureCodeMap, codeSizeDo);
//                if (MapUtils.isNotEmpty(featureCodeMap) && featureCodeMap.size() <= 6 && Math.random() < 0.05) {
//                    logger.info("深度模型预估 modelId:{}, featureCodeMap：{}, codeSizeDo: {}, ret: {}", modelId, featureCodeMap, codeSizeDo, ret);
//                }


            }
        } catch (Exception e) {

            logger.info(modelId + " predictWithTF warn ", e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }

    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFV3(Map<T, FeatureMapDo> featureMap, LocalTFModelV2 localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
            if (AssertUtil.isNotEmpty(featureMap)) {


                if (localTFModel == null) {
                    logger.info(modelId + " predictWithLocalTFV3,local model is null");
                }

                /**
                 * 获取特征编码
                 */
                //Map<T, CodeDo> featureCodeMap = getPredDenseCodes(featureMap, null, false, false);
                Map<T, CodeDo> featureCodeMap = getPredDenseCodes(featureMap, localTFModel.getVersion());
                CodeSizeDo codeSizeDo = getCodeSize();

                if (AssertUtil.isEmpty(featureCodeMap)) {
                    logger.info(modelId + " predictWithLocalTFV3,feature is null");
                }
                ret = localTFModel.predictAll(featureCodeMap, codeSizeDo);
//                if (MapUtils.isNotEmpty(featureCodeMap) && featureCodeMap.size() <= 6 && Math.random() < 0.05) {
//                    logger.info("深度模型预估 modelId:{}, featureCodeMap：{}, codeSizeDo: {}, ret: {}", modelId, featureCodeMap, codeSizeDo, ret);
//                }

                String cvrMapStr= null;
                if(featureMap.size()<20){
                    cvrMapStr= JSON.toJSONString(ret);
                }

                for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                    FeatureMapDo featureMapDo = entry.getValue();
                    T key = entry.getKey();
                    Double preValue= ret.get(key);
                    logger.info("set了codestr");
                    if (!AssertUtil.isEmpty(featureMapDo)) {
                        logger.info("key: {}, preValue: {}, featuremap: {}, codestr: {}", key, preValue, featureMapDo.getFeatureMap(), featureMapDo.getCodeDoStr());
                    }
                    featureMapDo.setCodeDoStr(cvrMapStr+";"+preValue+";"+featureMapDo.getCodeDoStr());
                }


            }
        } catch (Exception e) {

            logger.info(modelId + " predictWithTF warn ", e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }

    /**
     * 废弃
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        return null;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        return null;
    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        return null;
    }


    /**
     * 废弃
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * 废弃
     */
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {

        Map<T, Double> ret = null;

        return ret;
    }


    public static void main(String[] args) {

        DeepModelV2 coder = new DeepModelV2();

        Map<String, Map<String, Integer>> map = new HashMap<>();

        Map<String, Integer> map1 = new HashMap<>();
        map1.put("0", 999);
        map1.put("101", 1001);
        map1.put("102", 1002);
        map1.put("103", 1003);
        map1.put("104", 1004);
        map1.put("105", 1005);

        map.put("f1001", map1);


        Map<String, Integer> map2 = new HashMap<>();
        map2.put("0", 999);
        map2.put("1", 2000);
        map2.put("2", 2002);
        map2.put("3", 2003);
        map2.put("4", 2004);
        map.put("f1002", map2);


        FeatureBaseType2 featureBaseType1 = new FeatureBaseType2();
        featureBaseType1.setCodeType(1);
        featureBaseType1.setFeatureId("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1);
        featureBaseType1.setSplitChar(",");


        FeatureBaseType2 featureBaseType2 = new FeatureBaseType2();
        featureBaseType2.setCodeType(2);
        featureBaseType2.setFeatureId("f1002");
        featureBaseType2.setDenseLen(1000);
        featureBaseType2.setSubLen(4);
        featureBaseType2.setSplitChar(",");

        FeatureBaseType2 featureBaseType3 = new FeatureBaseType2();
        featureBaseType3.setCodeType(3);
        featureBaseType3.setFeatureId("f1003");
        featureBaseType3.setDenseLen(2);
        featureBaseType3.setSubLen(4);
        featureBaseType3.setSplitChar(",");


        List<FeatureBaseType2> list = Arrays.asList(featureBaseType1, featureBaseType1, featureBaseType2, featureBaseType2, featureBaseType3);

        coder.setFeatureDenseCoderMap(map);
        coder.setFeatureList(list);

        String coderStr = JSON.toJSONString(coder);

        DeepModel coder1 = JSON.parseObject(coderStr, DeepModel.class);

        System.out.println(coderStr);
        System.out.println(JSON.toJSONString(coder1));


        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f1001", "104");
        featureMap.put("f10011", "104");
        featureMap.put("f1002", null);

        Map<String, String> featureMap2 = new HashMap<>();

        featureMap2.put("f1003", "0.1");


        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();

        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDo.setDynamicFeatureMap(featureMap2);
        featureMapDoMap.put("s1", featureMapDo);

        Map<String, Map<String, String>> featureMapMap2 = new HashMap<>();
        featureMapMap2.put("s11", featureMapDo.getFeatureMap());
        try {

            Map<String, CodeDo> ret = coder.getPredDenseCodes(featureMapDoMap, null, false, false);
            System.out.println("c1=" + JSON.toJSONString(ret));
            Map<String, CodeDo> ret2 = coder.getSampleDenses(featureMapMap2, null);
            System.out.println("c2=" + JSON.toJSONString(ret2));


            coder.printInfo();


        } catch (Exception e) {

            System.out.println(e);
        }

    }

}
