/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.HyperParams;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESMMV3
implements Serializable {
    private static final long serialVersionUID = -316102112618444131L;
    private static final Logger logger = LoggerFactory.getLogger(ESMMV3.class);
    private int PB_MAX_SIZE = 128;
    private Integer algType;
    private IModel ctrModel;
    private IModel cvrModel;
    private LocalTFModelV2 ctrLocalTFModel;
    private LocalTFModelV2 cvrLocalTFModel;
    private MutModelType mutModelType;
    private Boolean isTmp;

    public ESMMV3(IModel ctrModel, IModel cvrModel, LocalTFModelV2 ctrLocalTFModel, LocalTFModelV2 cvrLocalTFModel, MutModelType mutModelType) {
        this.ctrModel = ctrModel;
        this.cvrModel = cvrModel;
        this.ctrLocalTFModel = ctrLocalTFModel;
        this.cvrLocalTFModel = cvrLocalTFModel;
        this.mutModelType = mutModelType;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRs(Map<T, FeatureMapDo> featureMap, Map<HyperParams, Double> params) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = null;
        if (MutModelType.DEBIAS == this.mutModelType) {
            ret = this.predictCTRsAndCVRsLocalTFNew(featureMap);
            Map<T, Double> cvrPrd = ret.get((Object)PredictResultType.CVR);
            Map<T, Double> newCvrPrd = ret.get((Object)PredictResultType.CVR);
            Double sampleRate = params.getOrDefault((Object)HyperParams.NCW, 1.0);
            for (Map.Entry<T, Double> entry : cvrPrd.entrySet()) {
                Double prob = entry.getValue();
                newCvrPrd.put(entry.getKey(), prob / (prob + (1.0 - prob) / sampleRate));
            }
            ret.put(PredictResultType.CVR, newCvrPrd);
        } else if (MutModelType.DEEP_E2E_LOCAL == this.mutModelType) {
            ret = this.predictCTRsAndCVRsLocalTFNew(featureMap);
        }
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsLocalTFNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        if (Objects.equals(this.isTmp, Boolean.TRUE)) {
            logger.info("\u6a21\u578b\u9884\u70ed, algType: {}", (Object)this.algType);
        }
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<Object, Object> ctrMap = new HashMap();
        if (this.ctrLocalTFModel != null) {
            ctrMap = this.ctrModel.predictWithLocalTFV2(featureMap, this.ctrLocalTFModel);
        }
        Map<Object, Object> cvrMap = new HashMap();
        if (this.cvrLocalTFModel != null) {
            cvrMap = this.cvrModel.predictWithLocalTFV2(featureMap, this.cvrLocalTFModel);
        }
        String cvrMapStr = null;
        if (featureMap.size() < 40) {
            cvrMapStr = JSON.toJSONString(cvrMap);
        }
        for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
            FeatureMapDo featureMapDo = entry.getValue();
            T key = entry.getKey();
            Double preValue = (Double)cvrMap.get(key);
            featureMapDo.setCodeDoStr(cvrMapStr + ";" + this.cvrLocalTFModel.getVersion() + ";" + preValue + ";" + featureMapDo.getCodeDoStr());
        }
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap, cvrMap})) {
            ret.put(PredictResultType.CTR, ctrMap);
            ret.put(PredictResultType.CVR, cvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    public static void main(String[] args) {
        HashMap<String, Double> ctrMap = new HashMap<String, Double>(10);
        ctrMap.put("1", 0.01);
        HashMap<String, Double> cvrMap = new HashMap<String, Double>(10);
        cvrMap.put("2", 0.22);
        System.out.println(AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap, cvrMap}));
    }

    private <T> Map<T, List<Float>> getParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    private <T> Map<T, List<Float>> getParamsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, FeatureMapDo> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    private List<Float> paramsSplicing(List<Float> ctrP, List<Float> cvrP) {
        ctrP.addAll(cvrP);
        return ctrP;
    }

    public int getPB_MAX_SIZE() {
        return this.PB_MAX_SIZE;
    }

    public Integer getAlgType() {
        return this.algType;
    }

    public IModel getCtrModel() {
        return this.ctrModel;
    }

    public IModel getCvrModel() {
        return this.cvrModel;
    }

    public LocalTFModelV2 getCtrLocalTFModel() {
        return this.ctrLocalTFModel;
    }

    public LocalTFModelV2 getCvrLocalTFModel() {
        return this.cvrLocalTFModel;
    }

    public MutModelType getMutModelType() {
        return this.mutModelType;
    }

    public Boolean getIsTmp() {
        return this.isTmp;
    }

    public void setPB_MAX_SIZE(int PB_MAX_SIZE) {
        this.PB_MAX_SIZE = PB_MAX_SIZE;
    }

    public void setAlgType(Integer algType) {
        this.algType = algType;
    }

    public void setCtrModel(IModel ctrModel) {
        this.ctrModel = ctrModel;
    }

    public void setCvrModel(IModel cvrModel) {
        this.cvrModel = cvrModel;
    }

    public void setCtrLocalTFModel(LocalTFModelV2 ctrLocalTFModel) {
        this.ctrLocalTFModel = ctrLocalTFModel;
    }

    public void setCvrLocalTFModel(LocalTFModelV2 cvrLocalTFModel) {
        this.cvrLocalTFModel = cvrLocalTFModel;
    }

    public void setMutModelType(MutModelType mutModelType) {
        this.mutModelType = mutModelType;
    }

    public void setIsTmp(Boolean isTmp) {
        this.isTmp = isTmp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESMMV3)) {
            return false;
        }
        ESMMV3 other = (ESMMV3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPB_MAX_SIZE() != other.getPB_MAX_SIZE()) {
            return false;
        }
        Integer this$algType = this.getAlgType();
        Integer other$algType = other.getAlgType();
        if (this$algType == null ? other$algType != null : !((Object)this$algType).equals(other$algType)) {
            return false;
        }
        IModel this$ctrModel = this.getCtrModel();
        IModel other$ctrModel = other.getCtrModel();
        if (this$ctrModel == null ? other$ctrModel != null : !this$ctrModel.equals(other$ctrModel)) {
            return false;
        }
        IModel this$cvrModel = this.getCvrModel();
        IModel other$cvrModel = other.getCvrModel();
        if (this$cvrModel == null ? other$cvrModel != null : !this$cvrModel.equals(other$cvrModel)) {
            return false;
        }
        LocalTFModelV2 this$ctrLocalTFModel = this.getCtrLocalTFModel();
        LocalTFModelV2 other$ctrLocalTFModel = other.getCtrLocalTFModel();
        if (this$ctrLocalTFModel == null ? other$ctrLocalTFModel != null : !((Object)this$ctrLocalTFModel).equals(other$ctrLocalTFModel)) {
            return false;
        }
        LocalTFModelV2 this$cvrLocalTFModel = this.getCvrLocalTFModel();
        LocalTFModelV2 other$cvrLocalTFModel = other.getCvrLocalTFModel();
        if (this$cvrLocalTFModel == null ? other$cvrLocalTFModel != null : !((Object)this$cvrLocalTFModel).equals(other$cvrLocalTFModel)) {
            return false;
        }
        MutModelType this$mutModelType = this.getMutModelType();
        MutModelType other$mutModelType = other.getMutModelType();
        if (this$mutModelType == null ? other$mutModelType != null : !((Object)((Object)this$mutModelType)).equals((Object)other$mutModelType)) {
            return false;
        }
        Boolean this$isTmp = this.getIsTmp();
        Boolean other$isTmp = other.getIsTmp();
        return !(this$isTmp == null ? other$isTmp != null : !((Object)this$isTmp).equals(other$isTmp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ESMMV3;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPB_MAX_SIZE();
        Integer $algType = this.getAlgType();
        result = result * 59 + ($algType == null ? 43 : ((Object)$algType).hashCode());
        IModel $ctrModel = this.getCtrModel();
        result = result * 59 + ($ctrModel == null ? 43 : $ctrModel.hashCode());
        IModel $cvrModel = this.getCvrModel();
        result = result * 59 + ($cvrModel == null ? 43 : $cvrModel.hashCode());
        LocalTFModelV2 $ctrLocalTFModel = this.getCtrLocalTFModel();
        result = result * 59 + ($ctrLocalTFModel == null ? 43 : ((Object)$ctrLocalTFModel).hashCode());
        LocalTFModelV2 $cvrLocalTFModel = this.getCvrLocalTFModel();
        result = result * 59 + ($cvrLocalTFModel == null ? 43 : ((Object)$cvrLocalTFModel).hashCode());
        MutModelType $mutModelType = this.getMutModelType();
        result = result * 59 + ($mutModelType == null ? 43 : ((Object)((Object)$mutModelType)).hashCode());
        Boolean $isTmp = this.getIsTmp();
        result = result * 59 + ($isTmp == null ? 43 : ((Object)$isTmp).hashCode());
        return result;
    }

    public String toString() {
        return "ESMMV3(PB_MAX_SIZE=" + this.getPB_MAX_SIZE() + ", algType=" + this.getAlgType() + ", ctrModel=" + this.getCtrModel() + ", cvrModel=" + this.getCvrModel() + ", ctrLocalTFModel=" + this.getCtrLocalTFModel() + ", cvrLocalTFModel=" + this.getCvrLocalTFModel() + ", mutModelType=" + (Object)((Object)this.getMutModelType()) + ", isTmp=" + this.getIsTmp() + ")";
    }
}

