package cn.com.duiba.nezha.alg.model.util;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import ai.onnxruntime.OrtSession;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OSSUtils {
    private static String endpoint = "oss-cn-hangzhou.aliyuncs.com"; //oss连接外网
    private static String accessKeyId = "LTAI5tAwVHc3eg6emfpr5smV";
    private static String accessKeySecret = "QT0G8v0NGixe6xhQi8xDMHdZ5lOSBb";

    public static String getLatestModelFromOSS(String bucketName, String dirName) throws Exception {
        // 创建OSS客户端
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
        String latestFileName = "";
        try {
            // 列出当前目录下的所有文件
            ObjectListing objectListing = ossClient.listObjects(bucketName, dirName);
            OSSObjectSummary latestFile = null;
            Date latestModifiedTime = null;

            for (OSSObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                // 排除目录本身
                if (objectSummary.getKey().equals(dirName)) {
                    continue;
                }
                // 获取文件的最后修改时间
                Date lastModified = objectSummary.getLastModified();
                // 比较最后修改时间，找到最新的文件
                if (latestModifiedTime == null || lastModified.after(latestModifiedTime)) {
                    latestModifiedTime = lastModified;
                    latestFile = objectSummary;
                }
            }

            if (latestFile != null) {
                latestFileName = latestFile.getKey();
            }
        } catch (Exception e) {
            System.out.println("OSS下载模型最新文件异常！" + e.getMessage());
        } finally {
            // 关闭OSS客户端
            ossClient.shutdown();
        }
        return latestFileName;
    }
    public static byte[] downloadModelFromOSS(String bucketName, String latestFileName) throws Exception {
        // 创建OSS客户端
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        try {
            // 下载文件
            InputStream inputStream = ossClient.getObject(new GetObjectRequest(bucketName, latestFileName)).getObjectContent();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            return outputStream.toByteArray();
        } finally {
            // 关闭OSS客户端
            ossClient.shutdown();
        }
    }
    public static Map<String, Map<String, Integer>> downloadFeatJsonFromOSS(String endpoint, String accessKeyId, String accessKeySecret, String bucketName, String objectName) throws Exception {
        OSS ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);

        try {
//            Map<String, Object> featureDictionary = new HashMap<>();
            // 下载文件
            InputStream inputStream = ossClient.getObject(new GetObjectRequest(bucketName, objectName)).getObjectContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder content = new StringBuilder();
            String line;

            while ((line = reader.readLine()) != null) {
                content.append(line);
            }
//            JSONObject jsonObject = new JSONObject(content.toString());
            ObjectMapper objectMapper = new ObjectMapper();
            Map<String, Map<String, Integer>> featEncoder = objectMapper.readValue(content.toString(), Map.class);
//            JsonNode jsonNode = objectMapper.readTree(content.toString());
//            Map<String, Object> featEncoder = jsonToJavaMap(jsonNode);
//            System.out.println(featEncoder);
            return featEncoder;
        } finally {
            // 关闭OSS客户端
            ossClient.shutdown();
        }
    }

    public static Map<String, Object> jsonToJavaMap(JsonNode jsonNode) {
        Map<String, Object> javaMap = new HashMap<>();

        Iterator<Map.Entry<String, JsonNode>> fields = jsonNode.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> field = fields.next();
            String key = field.getKey();
            JsonNode value = field.getValue();

            if (value.isObject()) {
                // 如果值是嵌套的JSON对象，递归处理
                javaMap.put(key, jsonToJavaMap(value));
            } else if (value.isArray()) {
                // 如果值是JSON数组，转换为List
                javaMap.put(key, jsonArrayToList(value));
            } else {
                // 直接添加键值对
                javaMap.put(key, value.asText());
            }
        }

        return javaMap;
    }

    public static Object jsonArrayToList(JsonNode jsonArray) {
        Object[] list = new Object[jsonArray.size()];

        for (int i = 0; i < jsonArray.size(); i++) {
            JsonNode value = jsonArray.get(i);

            if (value.isObject()) {
                // 如果数组元素是JSON对象，递归处理
                list[i] = jsonToJavaMap(value);
            } else if (value.isArray()) {
                // 如果数组元素是JSON数组，递归处理
                list[i] = jsonArrayToList(value);
            } else {
                // 直接添加数组元素
                list[i] = value.asText();
            }
        }

        return list;
    }
}
