package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.vo.ModelMetaData;
import lombok.Data;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

/**
 * 多编码器版本
 */
@Data
public class DeepModel2 extends DeepBaseModel implements Serializable, IModel {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DeepModel2.class);

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;
    public static Map<String, Integer> tmpIntMap = new HashMap<>();
    public static Map tmpMap = new HashMap<>();
    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型元数据集合
     * Map<模型ID, 模型元数据对象>
     */
    private Map<String, ModelMetaData> modelMetaMap;

    /**
     * 特征元数据集合
     * Map<特征ID, 特征元数据对象>
     */
    private Map<String, List<FeatureBaseType2>> featureListMap = new HashMap<>();

    /**
     * 特征编码集合
     * Map<特征ID, 特征Meta对象>
     */
    private Map<String, Map<String, Integer>> featureDenseCoderMap = new HashMap<>();


    /**
     * 模型预估环节，获取稠密编码
     *
     * @param featureMaps       特征对象
     * @param coderCache        全局缓存对象
     * @param hasSubCache       是否开启请求级别缓存
     * @param hasMultValueCache 多值特征是否开启缓存
     * @param subCoderId        模型ID
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, List<Integer>> getPredDenseCodes(Map<T, FeatureMapDo> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, boolean hasSubCache, boolean hasMultValueCache, String subCoderId) throws Exception {


        return getPredDenseCodes(featureMaps,
                coderCache,
                subCoderId,
                hasSubCache,
                hasMultValueCache,
                featureListMap.get(subCoderId),
                featureDenseCoderMap);
    }

    /**
     * 样本生成预估环节，获取稠密编码
     *
     * @param featureMaps
     * @param coderCache
     * @param hasMultValueCache
     * @param subCoderId
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, List<Integer>> getSampleDense(Map<T, Map<String, String>> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, boolean hasMultValueCache, String subCoderId) throws Exception {

        return getSampleDense(featureMaps,
                coderCache,
                subCoderId,
                featureListMap.get(subCoderId),
                featureDenseCoderMap);
    }


    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictLocalTF(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel, String coderId) throws Exception {
        Map<T, Double> ret = null;

        try {
            if (AssertUtil.isNotEmpty(featureMap)) {


                if (localTFModel == null) {
                    logger.info(modelId + " predictWithLocalTF,local model is null");
                }

                /**
                 * 获取特征编码
                 */
                Map<T, List<Integer>> featureCodeMap = getPredDenseCodes(featureMap, null, false, false, coderId);


                if (AssertUtil.isEmpty(featureCodeMap)) {
                    logger.info(modelId + " predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictInt(featureCodeMap);

            }
        } catch (Exception e) {

            logger.info(modelId + " predictWithTF warn ", e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }








    /**
     * 废弃
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        return null;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        return null;
    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        return null;
    }


    /**
     * 废弃
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * 废弃
     */
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }


    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }


    public static void main(String[] args) {

        DenseCoder coder = new DenseCoder();

        Map<String, Map<Integer, Integer>> map = new HashMap<>();

        Map<Integer, Integer> map1 = new HashMap<>();
        map1.put(0, 999);
        map1.put(101, 1001);
        map1.put(102, 1002);
        map1.put(103, 1003);
        map1.put(104, 1004);
        map1.put(105, 1005);

        map.put("f1001", map1);
        Map<Integer, Integer> map2 = new HashMap<>();
        map2.put(0, 999);
        map2.put(1, 2000);
        map2.put(2, 2002);
        map2.put(3, 2003);
        map2.put(4, 2004);
        map.put("f1002", map2);


        FeatureBaseType featureBaseType1 = new FeatureBaseType();
        featureBaseType1.setCodeType(11);
        featureBaseType1.setName("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1000000);
        featureBaseType1.setHashNums(1);
        featureBaseType1.setSeq(",");

        FeatureBaseType featureBaseType2 = new FeatureBaseType();
        featureBaseType2.setCodeType(41);
        featureBaseType2.setName("f1002");
        featureBaseType2.setDenseLen(10000);
        featureBaseType2.setSubLen(4);
        featureBaseType2.setHashNums(1);
        featureBaseType2.setSeq(",");


        List<FeatureBaseType> list = Arrays.asList(featureBaseType1);

        coder.setCoderMap(map);
        coder.setFeatureBaseType(list);

        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f1001", "100,104");
        featureMap.put("f1002", "0.9,1.0,1.1,1.34");


        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);

        try {
//            coder.getCodesNew(featureMapDoMap);
//            System.out.println(JSON.toJSONString(coder.getDenseCodes(featureMapDoMap)));
//            featureMap.put("f1001", "100,104,105");
//            System.out.println(JSON.toJSONString(coder.getDenseCodes(featureMapDoMap)));
//            coder.getCode2(featureMap);

        } catch (Exception e) {

            System.out.println(e);
        }

    }

}
