/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepBaseModel {
    private static final Logger logger = LoggerFactory.getLogger(DeepBaseModel.class);
    private int FBT_MAX_SIZE = 64;
    private int PB_MAX_SIZE = 128;
    public static Map<String, Integer> tmpIntMap = new HashMap<String, Integer>();
    public static Map tmpMap = new HashMap();

    public <T> Map<T, List<Integer>> getPredDenseCodes(Map<T, FeatureMapDo> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, String modelId, boolean hasSubCache, boolean hasMultValueCache, List<FeatureBaseType2> featureList, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        HashMap<T, List<Integer>> ret = new HashMap<T, List<Integer>>(this.PB_MAX_SIZE);
        Object subCoderCache = null;
        if (hasSubCache) {
            coderCache = new HashMap<String, Map<String, List<Integer>>>();
            hasMultValueCache = true;
        }
        if (AssertUtil.isNotEmpty(featureMaps)) {
            for (Map.Entry<T, FeatureMapDo> entry : featureMaps.entrySet()) {
                FeatureMapDo featureMapDo = entry.getValue();
                ret.put(entry.getKey(), this.getDenseCode(featureMapDo.staticFeatureMap, featureMapDo.dynamicFeatureMap, coderCache, hasMultValueCache, modelId, featureList, featureDenseCoderMap));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn(modelId + " getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    public <T> Map<T, List<Integer>> getSampleDense(Map<T, Map<String, String>> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, String modelId, List<FeatureBaseType2> featureList, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        HashMap<T, List<Integer>> ret = new HashMap<T, List<Integer>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMaps)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMaps.entrySet()) {
                ret.put(entry.getKey(), this.getDenseCode(entry.getValue(), null, coderCache, false, modelId, featureList, featureDenseCoderMap));
            }
        }
        if (AssertUtil.isEmpty(ret)) {
            logger.warn(modelId + " getCodes is invalid, featureMap is null or {}");
        }
        return ret;
    }

    public List<Integer> getDenseCode(Map<String, String> staticFeatureMap, Map<String, String> dynamicFeatureMap, Map<String, Map<String, List<Integer>>> coderCache, boolean hasStaticMultValueCache, String modelId, List<FeatureBaseType2> featureList, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        try {
            if (staticFeatureMap == null) {
                staticFeatureMap = tmpMap;
            }
            if (dynamicFeatureMap == null) {
                dynamicFeatureMap = tmpMap;
            }
            for (FeatureBaseType2 featureBaseType : featureList) {
                String value;
                List<Object> retSub = new ArrayList();
                String string = value = dynamicFeatureMap.get(featureBaseType.featureName) == null ? (String)staticFeatureMap.get(featureBaseType.featureName) : (String)dynamicFeatureMap.get(featureBaseType.featureName);
                if (coderCache != null && (featureBaseType.subLen > 1 || hasStaticMultValueCache)) {
                    Map<String, List<Integer>> cache = coderCache.getOrDefault(featureBaseType.featureName, tmpMap);
                    if (!cache.containsKey(value)) {
                        cache.put(value, this.getFieldDenseCode(featureBaseType, value, featureDenseCoderMap));
                    }
                    retSub = cache.get(value);
                } else {
                    retSub = this.getFieldDenseCode(featureBaseType, value, featureDenseCoderMap);
                }
                ret.addAll(retSub);
            }
        }
        catch (Exception e) {
            logger.warn(modelId + " getDenseCode ", (Throwable)e);
        }
        return ret;
    }

    public List<Integer> getFieldDenseCode(FeatureBaseType2 featureBaseType, String featureValue, Map<String, Map<String, Integer>> featureDenseCoderMap) throws Exception {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        String featureValueStd = FeatureBaseType2.std((String)featureValue);
        if (featureBaseType.subLen == 1) {
            ret.add(featureDenseCoderMap.getOrDefault(featureBaseType.featureName, tmpIntMap).getOrDefault(featureValueStd, 0));
        }
        if (featureBaseType.subLen > 1) {
            String[] featureArray = featureBaseType.split(featureValueStd);
            int featuresSize = featureArray == null ? 0 : featureArray.length;
            for (int i = 0; i < featureBaseType.subLen; ++i) {
                if (i < featuresSize) {
                    String valueStd = FeatureBaseType2.std((String)featureArray[i]);
                    ret.add(featureDenseCoderMap.getOrDefault(featureBaseType.featureName, tmpIntMap).getOrDefault(valueStd, 0));
                    continue;
                }
                ret.add(0);
            }
        }
        return ret;
    }

    public int getFBT_MAX_SIZE() {
        return this.FBT_MAX_SIZE;
    }

    public int getPB_MAX_SIZE() {
        return this.PB_MAX_SIZE;
    }

    public void setFBT_MAX_SIZE(int FBT_MAX_SIZE) {
        this.FBT_MAX_SIZE = FBT_MAX_SIZE;
    }

    public void setPB_MAX_SIZE(int PB_MAX_SIZE) {
        this.PB_MAX_SIZE = PB_MAX_SIZE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeepBaseModel)) {
            return false;
        }
        DeepBaseModel other = (DeepBaseModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFBT_MAX_SIZE() != other.getFBT_MAX_SIZE()) {
            return false;
        }
        return this.getPB_MAX_SIZE() == other.getPB_MAX_SIZE();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeepBaseModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFBT_MAX_SIZE();
        result = result * 59 + this.getPB_MAX_SIZE();
        return result;
    }

    public String toString() {
        return "DeepBaseModel(FBT_MAX_SIZE=" + this.getFBT_MAX_SIZE() + ", PB_MAX_SIZE=" + this.getPB_MAX_SIZE() + ")";
    }
}

