/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.model.IModel;
import cn.com.duiba.nezha.alg.model.enums.MutModelType;
import cn.com.duiba.nezha.alg.model.enums.PredictResultType;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalESMM
implements Serializable {
    private static final long serialVersionUID = -316102112618444131L;
    private static final Logger logger = LoggerFactory.getLogger(LocalESMM.class);
    private int PB_MAX_SIZE = 128;
    private IModel ctrModel;
    private IModel cvrModel;
    private LocalTFModel ctrLocalTFModel;
    private LocalTFModel cvrLocalTFModel;
    private MutModelType mutModelType;

    public LocalTFModel getCtrLocalTFModel() {
        return this.ctrLocalTFModel;
    }

    public void setCtrLocalTFModel(LocalTFModel ctrLocalTFModel) {
        this.ctrLocalTFModel = ctrLocalTFModel;
    }

    public LocalTFModel getCvrLocalTFModel() {
        return this.cvrLocalTFModel;
    }

    public void setCvrLocalTFModel(LocalTFModel cvrLocalTFModel) {
        this.cvrLocalTFModel = cvrLocalTFModel;
    }

    public MutModelType getMutModelType() {
        return this.mutModelType;
    }

    public void setMutModelType(MutModelType mutModelType) {
        this.mutModelType = mutModelType;
    }

    public LocalESMM(IModel ctrModel, IModel cvrModel, LocalTFModel ctrLocalTFModel, LocalTFModel cvrLocalTFModel, MutModelType mutModelType) {
        this.ctrModel = ctrModel;
        this.cvrModel = cvrModel;
        this.ctrLocalTFModel = ctrLocalTFModel;
        this.cvrLocalTFModel = cvrLocalTFModel;
        this.mutModelType = mutModelType;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRsWithTF(Map<T, Map<String, String>> featureMap) throws Exception {
        Map<PredictResultType, Map<T, Double>> ret = null;
        ret = MutModelType.CTR == this.mutModelType ? this.predictCTRs(featureMap) : (MutModelType.DEEP_ESMM == this.mutModelType ? this.ctrLocalTFModel.predictESMM(this.getESMMParams(featureMap)) : this.predictCTRsAndCVRs(featureMap));
        return ret;
    }

    public <T> Map<PredictResultType, Map<T, Double>> predictCTRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithLocalTF(featureMap, this.ctrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap})) {
            ret.put(PredictResultType.CTR, ctrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    private <T> Map<PredictResultType, Map<T, Double>> predictCTRsAndCVRs(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<PredictResultType, Map<T, Double>> ret = new HashMap<PredictResultType, Map<T, Double>>(this.PB_MAX_SIZE);
        Map<T, Double> ctrMap = this.ctrModel.predictWithLocalTF(featureMap, this.ctrLocalTFModel);
        Map<T, Double> cvrMap = this.cvrModel.predictWithLocalTF(featureMap, this.cvrLocalTFModel);
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ctrMap, cvrMap})) {
            ret.put(PredictResultType.CTR, ctrMap);
            ret.put(PredictResultType.CVR, cvrMap);
        } else {
            ret = null;
        }
        return ret;
    }

    private <T> Map<T, List<Float>> getESMMParams(Map<T, Map<String, String>> featureMap) throws Exception {
        HashMap<T, List<Float>> ret = new HashMap<T, List<Float>>(this.PB_MAX_SIZE);
        if (AssertUtil.isNotEmpty(featureMap)) {
            for (Map.Entry<T, Map<String, String>> entry : featureMap.entrySet()) {
                List<Float> ctrP = this.ctrModel.getParam(entry.getValue());
                List<Float> cvrP = this.cvrModel.getParam(entry.getValue());
                ret.put(entry.getKey(), this.paramsSplicing(ctrP, cvrP));
            }
        }
        return ret;
    }

    private List<Float> paramsSplicing(List<Float> ctrP, List<Float> cvrP) {
        ctrP.addAll(cvrP);
        return ctrP;
    }
}

