package cn.com.duiba.nezha.alg.model;

import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.feature.type.FeatureBaseType2;
import cn.com.duiba.nezha.alg.feature.vo.FeatureMapDo;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.nezha.alg.model.tf.TFServingClient;
import cn.com.duiba.nezha.alg.model.util.CollectionUtil;
import cn.com.duiba.nezha.alg.model.vo.CodeDo;
import cn.com.duiba.nezha.alg.model.vo.CodeSizeDo;
import cn.com.duiba.nezha.alg.model.vo.ModelMetaData;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

/**
 * 单编码器版本
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class DeepModelV2 extends DeepBaseModelV2 implements Serializable, IModel {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(DeepModelV2.class);

    private int FBT_MAX_SIZE = 64;

    private int PB_MAX_SIZE = 128;
    public static Map<String, Integer> tmpIntMap = new HashMap<>();
    public static Map tmpMap = new HashMap<>();
    /**
     * 模型ID
     */
    private String modelId;

    /**
     * 更新时间
     */
    private String updateTime;

    /**
     * 模型元数据集合
     * Map<模型ID, 模型元数据对象>
     */
    private ModelMetaData modelMeta;

    /**
     * 特征元数据集合
     * Map<特征ID, 特征元数据对象>
     */
    private List<FeatureBaseType2> featureList = new ArrayList<>();

    private CodeSizeDo codeSizeDo = null;

    /**
     * 特征编码集合
     * Map<特征ID, 特征Meta对象>
     */
    private Map<String, Map<String, Integer>> featureDenseCoderMap = new HashMap<>();


    /**
     * 模型预估环节，获取稠密编码
     *
     * @param featureMaps       特征对象
     * @param coderCache        全局缓存对象
     * @param hasSubCache       是否开启请求级别缓存
     * @param hasMultValueCache 多值特征是否开启缓存
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, CodeDo> getPredDenseCodes(Map<T, FeatureMapDo> featureMaps, Map<String, Map<String, List<Integer>>> coderCache, boolean hasSubCache, boolean hasMultValueCache) throws Exception {

        return getPredDenseCodes(featureMaps,
                coderCache,
                modelId,
                hasSubCache,
                hasMultValueCache,
                featureList,
                featureDenseCoderMap);
    }

    public CodeSizeDo getCodeSize() throws Exception {
        if (codeSizeDo == null) {
            codeSizeDo = getCodeSize(featureList);
        }
        return codeSizeDo;
    }

    /**
     * 样本生成环节，获取稠密编码
     *
     * @param featureMaps
     * @param coderCache
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, CodeDo> getSampleDenses(Map<T, Map<String, String>> featureMaps, Map<String, Map<String, List<Integer>>> coderCache) throws Exception {

        return getSampleDenses(featureMaps,
                coderCache,
                modelId,
                featureList,
                featureDenseCoderMap);

    }

    /**
     * 样本生成环节，获取稠密编码
     *
     * @param featureMap
     * @param coderCache
     * @return
     * @throws Exception
     */
    public CodeDo getSampleDense(Map<String, String> featureMap, Map<String, Map<String, List<Integer>>> coderCache) throws Exception {

        return getSampleDense(featureMap,
                coderCache,
                modelId,
                featureList,
                featureDenseCoderMap);
    }

    public static String toString(CodeDo codeDo) throws Exception{
        String ret = null;
        if (AssertUtil.isNotEmpty(codeDo.getSingleCode() )) {
            String sCode = CollectionUtil.toString(codeDo.getSingleCode(), ",");
            ret += sCode;
        }
        if (AssertUtil.isNotEmpty(codeDo.getMultiCode())) {
            String mCode = CollectionUtil.toString(codeDo.getMultiCode(), ",");
            ret += mCode;
        }
        if (AssertUtil.isNotEmpty(codeDo.getFloatCode())) {
            String fCode = CollectionUtil.toString(codeDo.getFloatCode(), ",");
            ret += fCode;
        }
        return ret;

    }

    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFV2(Map<T, FeatureMapDo> featureMap, LocalTFModelV2 localTFModel) throws Exception {
        Map<T, Double> ret = null;

        try {
            if (AssertUtil.isNotEmpty(featureMap)) {


                if (localTFModel == null) {
                    logger.info(modelId + " predictWithLocalTF,local model is null");
                }

                /**
                 * 获取特征编码
                 */
                Map<T, CodeDo> featureCodeMap = getPredDenseCodes(featureMap, null, false, false);

                CodeSizeDo codeSizeDo = getCodeSizeDo();

                if (AssertUtil.isEmpty(featureCodeMap)) {
                    logger.info(modelId + " predictWithLocalTF,feature is null");
                }
                ret = localTFModel.predictAll(featureCodeMap, codeSizeDo);

            }
        } catch (Exception e) {

            logger.info(modelId + " predictWithTF warn ", e);
            ret = predictsNew(featureMap);
        } finally {
//            DBTimeProfile.release();
        }

        return ret;
    }


    /**
     * 废弃
     */
    public Double predict(Map<String, String> featureMap) throws Exception {
        return null;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predicts(Map<T, Map<String, String>> featureMap) throws Exception {
        return null;
    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictsNew(Map<T, FeatureMapDo> featureMap) throws Exception {
        return null;
    }


    /**
     * 废弃
     */
    public List<Float> getParam(Map<String, String> featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }

    /**
     * 废弃
     */
    public List<Float> getParam(FeatureMapDo featureMap) throws Exception {
        List<Float> ret = null;

        return ret;

    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithTF(Map<T, Map<String, String>> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithTFNew(Map<T, FeatureMapDo> featureMap, TFServingClient tfServingClient) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }


    /**
     * 废弃
     */
    public <T> Map<T, Double> predictWithLocalTF(Map<T, Map<String, String>> featureMap, LocalTFModel localTFModel) throws Exception {
        Map<T, Double> ret = null;

        return ret;
    }

    /**
     * @param featureMap   预估样本集合
     * @param localTFModel 本地深度模型
     * @param <T>
     * @return
     * @throws Exception
     */
    public <T> Map<T, Double> predictWithLocalTFNew(Map<T, FeatureMapDo> featureMap, LocalTFModel localTFModel) throws Exception {

        Map<T, Double> ret = null;

        return ret;
    }


    public static void main(String[] args) {

        DeepModelV2 coder = new DeepModelV2();

        Map<String, Map<String, Integer>> map = new HashMap<>();

        Map<String, Integer> map1 = new HashMap<>();
        map1.put("0", 999);
        map1.put("101", 1001);
        map1.put("102", 1002);
        map1.put("103", 1003);
        map1.put("104", 1004);
        map1.put("105", 1005);

        map.put("f1001", map1);
        Map<String, Integer> map2 = new HashMap<>();
        map2.put("0", 999);
        map2.put("1", 2000);
        map2.put("2", 2002);
        map2.put("3", 2003);
        map2.put("4", 2004);
        map.put("f1002", map2);


        FeatureBaseType2 featureBaseType1 = new FeatureBaseType2();
        featureBaseType1.setCodeType(1);
        featureBaseType1.setFeatureId("f1001");
        featureBaseType1.setDenseLen(10000);
        featureBaseType1.setSubLen(1);
        featureBaseType1.setSplitChar(",");

        FeatureBaseType2 featureBaseType2 = new FeatureBaseType2();
        featureBaseType2.setCodeType(2);
        featureBaseType2.setFeatureId("f1002");
        featureBaseType2.setDenseLen(1000);
        featureBaseType2.setSubLen(4);
        featureBaseType2.setSplitChar(",");

        FeatureBaseType2 featureBaseType3 = new FeatureBaseType2();
        featureBaseType3.setCodeType(3);
        featureBaseType3.setFeatureId("f1003");
        featureBaseType3.setDenseLen(1000);
        featureBaseType3.setSubLen(4);
        featureBaseType3.setSplitChar(",");


        List<FeatureBaseType2> list = Arrays.asList(featureBaseType1, featureBaseType2, featureBaseType3);

        coder.setFeatureDenseCoderMap(map);
        coder.setFeatureList(list);

        String coderStr = JSON.toJSONString(coder);

        DeepModel coder1 = JSON.parseObject(coderStr, DeepModel.class);

        System.out.println(coderStr);
        System.out.println(JSON.toJSONString(coder1));


        Map<String, String> featureMap = new HashMap<>();
        featureMap.put("f1001", "104");
        featureMap.put("f1002", "0,3,9");
        featureMap.put("f1003", "0,");


        Map<String, FeatureMapDo> featureMapDoMap = new HashMap<>();
        FeatureMapDo featureMapDo = new FeatureMapDo();
        featureMapDo.setStaticFeatureMap(featureMap);
        featureMapDoMap.put("s1", featureMapDo);
        try {

            Map<String, CodeDo> ret = coder.getPredDenseCodes(featureMapDoMap, null, false, false);
            System.out.println(JSON.toJSONString(ret));
//            featureMap.put("f1001", "100,104,105");
//            System.out.println(JSON.toJSONString(coder.getDenseCodes(featureMapDoMap)));
//            coder.getCode2(featureMap);

        } catch (Exception e) {

            System.out.println(e);
        }

    }

}
