/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.stat;

import cn.com.duiba.nezha.alg.api.vo.PreDcvrStatInfo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import java.io.Serializable;

public class DcvrStatMerger
implements Serializable {
    public static PreDcvrStatInfo merge(PreDcvrStatInfo pastStatInfo, PreDcvrStatInfo currentStatInfo) {
        PreDcvrStatInfo ret = new PreDcvrStatInfo();
        if (pastStatInfo == null) {
            pastStatInfo = new PreDcvrStatInfo();
        }
        if (currentStatInfo == null) {
            currentStatInfo = new PreDcvrStatInfo();
        }
        ret = currentStatInfo;
        Double decayFactor = DcvrStatMerger.getDecayFactor(pastStatInfo.getPastPV(), currentStatInfo.getCurrentPV());
        Long pv = DcvrStatMerger.mergeNew(pastStatInfo.getPastPV(), currentStatInfo.getCurrentPV(), decayFactor);
        Double sum = DcvrStatMerger.mergeNew(pastStatInfo.getPastSum(), currentStatInfo.getCurrentSum(), decayFactor);
        Double squareSum = DcvrStatMerger.mergeNew(pastStatInfo.getPastSquareSum(), currentStatInfo.getCurrentSquareSum(), decayFactor);
        ret.setPastPV(pv);
        ret.setPastSum(sum);
        ret.setPastSquareSum(squareSum);
        DcvrStatMerger.updateMeanAndSD(ret, pv, sum, squareSum);
        ret.setUpdateTime(LocalDateUtil.getCurrentLocalDateTime((DateStyle)DateStyle.YYYY_MM_DD_HH_MM_SS));
        return ret;
    }

    public static void updateMeanAndSD(PreDcvrStatInfo preDcvrStatInfo, Long pv, Double sum, Double squareSum) {
        if (preDcvrStatInfo != null && pv > 5000L && sum > 0.001 && squareSum > 1.0E-4) {
            Double mean = sum / (double)pv.longValue();
            Double variance = squareSum / (double)(pv - 1L) - mean * mean;
            Double sd = Math.sqrt(variance);
            mean = MathUtil.stdwithBoundary((double)mean, (double)0.03, (double)0.9);
            sd = MathUtil.stdwithBoundary((double)sd, (double)0.01, (double)0.3);
            preDcvrStatInfo.setMergeMean(DataUtil.formatDouble((Double)mean, (int)4));
            preDcvrStatInfo.setMergeSD(DataUtil.formatDouble((Double)sd, (int)4));
        }
    }

    public static Long mergeNew(Long passValue, Long currentValue, Double decayFactor) {
        Long ret = null;
        if (passValue == null) {
            passValue = 0L;
        }
        if (currentValue == null) {
            currentValue = 0L;
        }
        ret = decayFactor == null ? Long.valueOf(passValue + currentValue) : DataUtil.double2Long((Double)(decayFactor * (double)passValue.longValue() + (double)currentValue.longValue()));
        return ret;
    }

    public static Double mergeNew(Double passValue, Double currentValue, Double decayFactor) {
        Double ret = null;
        if (passValue == null) {
            passValue = 0.0;
        }
        if (currentValue == null) {
            currentValue = 0.0;
        }
        ret = decayFactor == null ? Double.valueOf(passValue + currentValue) : Double.valueOf(decayFactor * passValue + currentValue);
        return ret;
    }

    public static Double getDecayFactor(Long pastPv, Long currentPv) {
        Double ret = 0.0;
        ret = pastPv == null || pastPv < 10000L ? null : (currentPv == null || currentPv < 1000L ? Double.valueOf(0.98) : Double.valueOf(0.96));
        return ret;
    }

    public static void main(String[] args) {
        PreDcvrStatInfo pastStatInfo = new PreDcvrStatInfo();
        pastStatInfo.setPastPV(Long.valueOf(10000L));
        pastStatInfo.setPastSum(Double.valueOf(1000.0));
        pastStatInfo.setPastSquareSum(Double.valueOf(10.0));
        PreDcvrStatInfo currentStatInfo = new PreDcvrStatInfo();
        currentStatInfo.setCurrentPV(Long.valueOf(10000L));
        currentStatInfo.setCurrentSum(Double.valueOf(3949.694048));
        currentStatInfo.setCurrentSquareSum(Double.valueOf(1682.1002790000002));
        PreDcvrStatInfo ret = DcvrStatMerger.merge(null, currentStatInfo);
        System.out.println(JSON.toJSONString((Object)ret));
        for (int i = 0; i < 10; ++i) {
            ret = DcvrStatMerger.merge(ret, currentStatInfo);
            System.out.println(JSON.toJSONString((Object)ret));
        }
    }
}

