/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.mllib.optimizing;

import cn.com.duiba.nezha.compute.api.point.Point;
import cn.com.duiba.nezha.compute.mllib.util.MLUtil$;
import cn.com.duiba.nezha.compute.mllib.util.SparseUtil$;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;

public final class SparseFMUpdater$ {
    public static final SparseFMUpdater$ MODULE$;

    static {
        new SparseFMUpdater$();
    }

    public Point.FMParams update(Point.FMParams psOld, Point.FMGradParams grad, double learningRate, double r1, double r2) {
        double w0_new = this.updateW0(psOld.w0(), grad.grad_w0(), learningRate, r1, r2);
        SparseVector w_new = this.updateW(psOld.w(), grad.grad_w(), learningRate, r1, r2);
        SparseMatrix v_new = this.updateV(psOld.v(), grad.grad_v(), learningRate, r1, r2);
        return new Point.FMParams(w0_new, w_new, v_new);
    }

    public double updateW0(double w, double grad, double learningRate, double r1, double r2) {
        double p1 = (1.0 - learningRate * r2) * w;
        double p2 = learningRate * r1 * MLUtil$.MODULE$.sign(w) * w;
        double p3 = learningRate * grad;
        return p1 - p2 - p3;
    }

    public SparseVector updateW(SparseVector w, SparseVector grad, double learningRate, double r1, double r2) {
        SparseVector p1 = SparseUtil$.MODULE$.multiply(w, 1.0 - learningRate * r2);
        SparseVector p2_1 = SparseUtil$.MODULE$.multiply(MLUtil$.MODULE$.sign(w), w);
        SparseVector p2 = SparseUtil$.MODULE$.multiply(p2_1, learningRate * r1 * (double)-1);
        SparseVector p3 = SparseUtil$.MODULE$.multiply(grad, (double)-1 * learningRate);
        SparseVector p1_p2 = SparseUtil$.MODULE$.add(p1, p2);
        SparseVector p1_p2_p3 = SparseUtil$.MODULE$.add(p3, p1_p2);
        return p1_p2_p3;
    }

    public SparseMatrix updateV(SparseMatrix v, SparseMatrix grad, double learningRate, double r1, double r2) {
        SparseMatrix p1 = SparseUtil$.MODULE$.multiply(v, 1.0 - learningRate * r2);
        SparseMatrix p2_1 = SparseUtil$.MODULE$.multiply(MLUtil$.MODULE$.sign(v), v);
        SparseMatrix p2 = SparseUtil$.MODULE$.multiply(p2_1, learningRate * r1 * (double)-1);
        SparseMatrix p3 = SparseUtil$.MODULE$.multiply(grad, (double)-1 * learningRate);
        SparseMatrix p1_p2 = SparseUtil$.MODULE$.add(p1, p2);
        SparseMatrix p1_p2_p3 = SparseUtil$.MODULE$.add(p3, p1_p2);
        return p1_p2_p3;
    }

    private SparseFMUpdater$() {
        MODULE$ = this;
    }
}

