/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.mllib.util;

import breeze.generic.UFunc;
import breeze.numerics.package;
import cn.com.duiba.nezha.compute.api.constant.GlobalConstant;
import cn.com.duiba.nezha.compute.mllib.util.SparseUtil$;
import java.util.Random;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class SparseUtil$ {
    public static final SparseUtil$ MODULE$;

    static {
        new SparseUtil$();
    }

    public double sum(SparseVector sv1) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv1.values()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double sum(Vector sv1) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sv1.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double sum(SparseMatrix sm1) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sm1.values()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public double sum(Matrix sm1) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sm1.toArray()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public SparseVector sum_row2(SparseMatrix sm1_o) {
        SparseMatrix sm1 = this.transposeClean(sm1_o);
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach((Function1)new Serializable(sm1, r_indices, r_values){
            public static final long serialVersionUID = 0L;
            public final SparseMatrix sm1$1;
            private final ArrayBuffer r_indices$1;
            private final ArrayBuffer r_values$1;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                if (this.sm1$1.colPtrs()[i] < this.sm1$1.colPtrs()[i + 1]) {
                    DoubleRef s_s = new DoubleRef(0.0);
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.sm1$1.colPtrs()[i]), this.sm1$1.colPtrs()[i + 1] - 1).foreach$mVc$sp((Function1)new Serializable(this, s_s){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.sum_row2.1 $outer;
                        private final DoubleRef s_s$1;

                        public final void apply(int j) {
                            this.apply$mcVI$sp(j);
                        }

                        public void apply$mcVI$sp(int j) {
                            this.s_s$1.elem += this.$outer.sm1$1.values()[j];
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.s_s$1 = s_s$1;
                        }
                    });
                    this.r_indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = this.r_values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)s_s.elem));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.sm1$1 = sm1$1;
                this.r_indices$1 = r_indices$1;
                this.r_values$1 = r_values$1;
            }
        });
        return (SparseVector)Vectors$.MODULE$.sparse(sm1.numCols(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseVector sum_row(SparseMatrix sm1_o) {
        SparseMatrix sm1 = this.transposeClean(sm1_o);
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach((Function1)new Serializable(sm1, r_indices, r_values){
            public static final long serialVersionUID = 0L;
            private final SparseMatrix sm1$2;
            private final ArrayBuffer r_indices$2;
            private final ArrayBuffer r_values$2;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                double[] p1_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm1$2.values()).slice(this.sm1$2.colPtrs()[i], this.sm1$2.colPtrs()[i + 1]);
                if (Predef$.MODULE$.doubleArrayOps(p1_values).size() > 0) {
                    this.r_indices$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = this.r_values$2.$plus$eq(Predef$.MODULE$.doubleArrayOps(p1_values).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.sm1$2 = sm1$2;
                this.r_indices$2 = r_indices$2;
                this.r_values$2 = r_values$2;
            }
        });
        return (SparseVector)Vectors$.MODULE$.sparse(sm1.numCols(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public double rand(int seed) {
        Random rand2 = new Random(seed);
        return rand2.nextDouble();
    }

    public double rand(int seed, double proportion) {
        return this.rand(seed) * proportion;
    }

    public SparseVector rand(int size, int seed) {
        Random rand2 = new Random(seed);
        int[] ret_indices = Array$.MODULE$.range(0, size);
        double[] ret_values = (double[])Array$.MODULE$.tabulate(size, (Function1)new Serializable(rand2){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return this.rand$1.nextDouble();
            }
            {
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.Double());
        return (SparseVector)Vectors$.MODULE$.sparse(size, ret_indices, ret_values);
    }

    public SparseVector rand(int size, int seed, double proportion) {
        return this.multiply(this.rand(size, seed), proportion);
    }

    public SparseVector zero(int size) {
        int[] ret_indices = Array$.MODULE$.range(0, size);
        double[] ret_values = (double[])Array$.MODULE$.tabulate(size, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        return (SparseVector)Vectors$.MODULE$.sparse(size, ret_indices, ret_values);
    }

    public SparseVector ones(int size, double proportion) {
        int[] ret_indices = Array$.MODULE$.range(0, size);
        double[] ret_values = (double[])Array$.MODULE$.tabulate(size, (Function1)new Serializable(proportion){
            public static final long serialVersionUID = 0L;
            private final double proportion$2;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return this.proportion$2;
            }
            {
                this.proportion$2 = proportion$2;
            }
        }, ClassTag$.MODULE$.Double());
        return (SparseVector)Vectors$.MODULE$.sparse(size, ret_indices, ret_values);
    }

    public SparseMatrix rand(int numRows, int numCols, int seed) {
        Random rand2 = new Random(seed);
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numCols - 1).foreach((Function1)new Serializable(numRows, ret_rowIndices){
            public static final long serialVersionUID = 0L;
            private final int numRows$1;
            private final ArrayBuffer ret_rowIndices$1;

            public final ArrayBuffer<Object> apply(int i) {
                return this.ret_rowIndices$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, this.numRows$1)));
            }
            {
                this.numRows$1 = numRows$1;
                this.ret_rowIndices$1 = ret_rowIndices$1;
            }
        });
        int[] ret_colPtrs = (int[])Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, numCols + 1)).map((Function1)new Serializable(numRows){
            public static final long serialVersionUID = 0L;
            private final int numRows$1;

            public final int apply(int x) {
                return this.apply$mcII$sp(x);
            }

            public int apply$mcII$sp(int x) {
                return x * this.numRows$1;
            }
            {
                this.numRows$1 = numRows$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        double[] ret_values = (double[])Array$.MODULE$.tabulate(numRows * numCols, (Function1)new Serializable(rand2){
            public static final long serialVersionUID = 0L;
            private final Random rand$2;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return this.rand$2.nextDouble();
            }
            {
                this.rand$2 = rand$2;
            }
        }, ClassTag$.MODULE$.Double());
        return (SparseMatrix)Matrices$.MODULE$.sparse(numRows, numCols, (int[])Predef$.MODULE$.intArrayOps(ret_colPtrs).toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])Predef$.MODULE$.doubleArrayOps(ret_values).toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix rand(int numRows, int numCols, int seed, double proportion) {
        return this.multiply(this.rand(numRows, numCols, seed), proportion);
    }

    public SparseMatrix zero(int numRows, int numCols) {
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numCols - 1).foreach((Function1)new Serializable(numRows, ret_rowIndices){
            public static final long serialVersionUID = 0L;
            private final int numRows$2;
            private final ArrayBuffer ret_rowIndices$2;

            public final ArrayBuffer<Object> apply(int i) {
                return this.ret_rowIndices$2.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, this.numRows$2)));
            }
            {
                this.numRows$2 = numRows$2;
                this.ret_rowIndices$2 = ret_rowIndices$2;
            }
        });
        int[] ret_colPtrs = (int[])Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, numCols + 1)).map((Function1)new Serializable(numRows){
            public static final long serialVersionUID = 0L;
            private final int numRows$2;

            public final int apply(int x) {
                return this.apply$mcII$sp(x);
            }

            public int apply$mcII$sp(int x) {
                return x * this.numRows$2;
            }
            {
                this.numRows$2 = numRows$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        double[] ret_values = (double[])Array$.MODULE$.tabulate(numRows * numCols, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        return (SparseMatrix)Matrices$.MODULE$.sparse(numRows, numCols, (int[])Predef$.MODULE$.intArrayOps(ret_colPtrs).toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])Predef$.MODULE$.doubleArrayOps(ret_values).toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix ones(int numRows, int numCols, double proportion) {
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numCols - 1).foreach((Function1)new Serializable(numRows, ret_rowIndices){
            public static final long serialVersionUID = 0L;
            private final int numRows$3;
            private final ArrayBuffer ret_rowIndices$3;

            public final ArrayBuffer<Object> apply(int i) {
                return this.ret_rowIndices$3.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, this.numRows$3)));
            }
            {
                this.numRows$3 = numRows$3;
                this.ret_rowIndices$3 = ret_rowIndices$3;
            }
        });
        int[] ret_colPtrs = (int[])Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, numCols + 1)).map((Function1)new Serializable(numRows){
            public static final long serialVersionUID = 0L;
            private final int numRows$3;

            public final int apply(int x) {
                return this.apply$mcII$sp(x);
            }

            public int apply$mcII$sp(int x) {
                return x * this.numRows$3;
            }
            {
                this.numRows$3 = numRows$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        double[] ret_values = (double[])Array$.MODULE$.tabulate(numRows * numCols, (Function1)new Serializable(proportion){
            public static final long serialVersionUID = 0L;
            private final double proportion$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return this.proportion$1;
            }
            {
                this.proportion$1 = proportion$1;
            }
        }, ClassTag$.MODULE$.Double());
        return (SparseMatrix)Matrices$.MODULE$.sparse(numRows, numCols, (int[])Predef$.MODULE$.intArrayOps(ret_colPtrs).toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])Predef$.MODULE$.doubleArrayOps(ret_values).toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix vector_copy(SparseVector sv1, int numCols) {
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numCols - 1).foreach((Function1)new Serializable(sv1, ret_colPtrs, ret_rowIndices, ret_values){
            public static final long serialVersionUID = 0L;
            private final SparseVector sv1$2;
            private final ArrayBuffer ret_colPtrs$1;
            private final ArrayBuffer ret_rowIndices$4;
            private final ArrayBuffer ret_values$1;

            public final ArrayBuffer<Object> apply(int i) {
                this.ret_rowIndices$4.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(this.sv1$2.indices()));
                this.ret_values$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(this.sv1$2.values()));
                return this.ret_colPtrs$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.ret_colPtrs$1.apply(i)) + this.sv1$2.indices().length)));
            }
            {
                this.sv1$2 = sv1$2;
                this.ret_colPtrs$1 = ret_colPtrs$1;
                this.ret_rowIndices$4 = ret_rowIndices$4;
                this.ret_values$1 = ret_values$1;
            }
        });
        return (SparseMatrix)Matrices$.MODULE$.sparse(sv1.size(), numCols, (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix vector_copy_test(SparseVector sv1, int numCols) {
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numCols - 1).foreach((Function1)new Serializable(sv1, ret_colPtrs, ret_rowIndices, ret_values){
            public static final long serialVersionUID = 0L;
            private final SparseVector sv1$3;
            private final ArrayBuffer ret_colPtrs$2;
            private final ArrayBuffer ret_rowIndices$5;
            private final ArrayBuffer ret_values$2;

            public final ArrayBuffer<Object> apply(int i) {
                this.ret_rowIndices$5.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(this.sv1$3.indices()));
                this.ret_values$2.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(this.sv1$3.values()));
                return this.ret_colPtrs$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.ret_colPtrs$2.apply(i)) + this.sv1$3.indices().length)));
            }
            {
                this.sv1$3 = sv1$3;
                this.ret_colPtrs$2 = ret_colPtrs$2;
                this.ret_rowIndices$5 = ret_rowIndices$5;
                this.ret_values$2 = ret_values$2;
            }
        });
        return null;
    }

    public SparseVector multiply(Vector sv, double d) {
        return this.multiply(sv.toSparse(), d);
    }

    public SparseVector multiply(SparseVector sv, double d) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sv.values()).map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final double d$4;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i * this.d$4;
            }
            {
                this.d$4 = d$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseVector)Vectors$.MODULE$.sparse(sv.size(), sv.indices(), m_values);
    }

    public SparseMatrix multiply(SparseMatrix sm, double d) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sm.values()).map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final double d$3;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i * this.d$3;
            }
            {
                this.d$3 = d$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm.numRows(), sm.numCols(), sm.colPtrs(), sm.rowIndices(), m_values);
    }

    public SparseVector sqrt(SparseVector sv) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sv.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return package$.MODULE$.sqrt(i);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseVector)Vectors$.MODULE$.sparse(sv.size(), sv.indices(), m_values);
    }

    public SparseVector sqrt(Vector sv) {
        return this.sqrt(sv.toSparse());
    }

    public SparseMatrix sqrt(SparseMatrix sm) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sm.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return package$.MODULE$.sqrt(i);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm.numRows(), sm.numCols(), sm.colPtrs(), sm.rowIndices(), m_values);
    }

    public SparseVector inverse(SparseVector sv) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sv.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return 1.0 / (i + GlobalConstant.EPSILON);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseVector)Vectors$.MODULE$.sparse(sv.size(), sv.indices(), m_values);
    }

    public SparseMatrix inverse(SparseMatrix sm) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sm.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return 1.0 / (i + GlobalConstant.EPSILON);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm.numRows(), sm.numCols(), sm.colPtrs(), sm.rowIndices(), m_values);
    }

    public SparseVector add(SparseVector sv, double d) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sv.values()).map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final double d$2;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i + this.d$2;
            }
            {
                this.d$2 = d$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseVector)Vectors$.MODULE$.sparse(sv.size(), sv.indices(), m_values);
    }

    public SparseMatrix add(SparseMatrix sm, double d) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sm.values()).map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final double d$1;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i + this.d$1;
            }
            {
                this.d$1 = d$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm.numRows(), sm.numCols(), sm.colPtrs(), sm.rowIndices(), m_values);
    }

    public SparseVector add(SparseVector sv1, SparseVector sv2) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (sv1.size() != sv2.size()) {
            throw new Exception("add error ,params valid sv1.size != sv2.size");
        }
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        int i = 0;
        int j = 0;
        while (i < sv1.indices().length && j < sv2.indices().length) {
            int sv2_idx;
            int sv1_idx = sv1.indices()[i];
            if (sv1_idx < (sv2_idx = sv2.indices()[j])) {
                r_indices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)sv1_idx));
                r_values.$plus$eq((Object)BoxesRunTime.boxToDouble((double)sv1.values()[i]));
                ++i;
            }
            if (sv1_idx == sv2_idx) {
                BoxedUnit boxedUnit3;
                if (Math.abs(sv1.values()[i] + sv2.values()[j]) > GlobalConstant.DOUBLE_ZERO) {
                    r_indices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)sv1_idx));
                    boxedUnit3 = r_values.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(sv1.values()[i] + sv2.values()[j])));
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i;
                ++j;
            }
            if (sv1_idx <= sv2_idx) continue;
            r_indices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)sv2_idx));
            r_values.$plus$eq((Object)BoxesRunTime.boxToDouble((double)sv2.values()[j]));
            ++j;
        }
        if (i < sv1.indices().length) {
            r_indices.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(sv1.indices()).slice(i, sv1.indices().length)));
            boxedUnit2 = r_values.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(sv1.values()).slice(i, sv1.indices().length)));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (j < sv2.indices().length) {
            r_indices.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(sv2.indices()).slice(j, sv2.indices().length)));
            boxedUnit = r_values.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(sv2.values()).slice(j, sv2.indices().length)));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (SparseVector)Vectors$.MODULE$.sparse(sv1.size(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix add(SparseMatrix sm1_o, SparseMatrix sm2_o) {
        if (sm1_o.numRows() != sm2_o.numRows() || sm1_o.numCols() != sm2_o.numCols()) {
            throw new Exception("add error ,params valid sm1.numRows!=sm2.numRows || sm1.numCols!=sm2.numCols");
        }
        SparseMatrix sm1 = this.transposeClean(sm1_o);
        SparseMatrix sm2 = this.transposeClean(sm2_o);
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach((Function1)new Serializable(sm1, sm2, ret_colPtrs, ret_rowIndices, ret_values){
            public static final long serialVersionUID = 0L;
            private final SparseMatrix sm1$3;
            private final SparseMatrix sm2$2;
            private final ArrayBuffer ret_colPtrs$3;
            private final ArrayBuffer ret_rowIndices$6;
            private final ArrayBuffer ret_values$3;

            public final ArrayBuffer<Object> apply(int i) {
                int[] p1_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm1$3.rowIndices()).slice(this.sm1$3.colPtrs()[i], this.sm1$3.colPtrs()[i + 1]);
                double[] p1_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm1$3.values()).slice(this.sm1$3.colPtrs()[i], this.sm1$3.colPtrs()[i + 1]);
                SparseVector p1_Vector = (SparseVector)Vectors$.MODULE$.sparse(this.sm1$3.numRows(), p1_indices, p1_values);
                int[] p2_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm2$2.rowIndices()).slice(this.sm2$2.colPtrs()[i], this.sm2$2.colPtrs()[i + 1]);
                double[] p2_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm2$2.values()).slice(this.sm2$2.colPtrs()[i], this.sm2$2.colPtrs()[i + 1]);
                SparseVector p2_Vector = (SparseVector)Vectors$.MODULE$.sparse(this.sm1$3.numRows(), p2_indices, p2_values);
                SparseVector p_Vector = SparseUtil$.MODULE$.add(p1_Vector, p2_Vector);
                this.ret_rowIndices$6.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(p_Vector.indices()));
                this.ret_values$3.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(p_Vector.values()));
                return this.ret_colPtrs$3.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.ret_colPtrs$3.apply(i)) + p_Vector.indices().length)));
            }
            {
                this.sm1$3 = sm1$3;
                this.sm2$2 = sm2$2;
                this.ret_colPtrs$3 = ret_colPtrs$3;
                this.ret_rowIndices$6 = ret_rowIndices$6;
                this.ret_values$3 = ret_values$3;
            }
        });
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm1.numRows(), sm1.numCols(), (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseVector multiply2(SparseVector sv1, SparseVector sv2) {
        if (sv1.size() != sv2.size()) {
            throw new Exception("add error ,params valid sv1.size != sv2.size");
        }
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        SparseVector ret = (SparseVector)Vectors$.MODULE$.sparse(sv1.size(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
        if (sv1.indices().length != 0 && sv2.indices().length != 0) {
            ret = sv1.indices().length <= sv2.indices().length ? this.multiply_v_sv((Vector)sv2, sv1) : this.multiply_v_sv((Vector)sv1, sv2);
        }
        return ret;
    }

    public SparseVector multiply_v_sv(Vector v1, SparseVector sv2) {
        if (v1.size() != sv2.size()) {
            throw new Exception("multiply_v_sv error ,params valid v1.size != sv2.size");
        }
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sv2.indices().length - 1).foreach((Function1)new Serializable(v1, sv2, r_indices, r_values){
            public static final long serialVersionUID = 0L;
            private final Vector v1$1;
            private final SparseVector sv2$1;
            private final ArrayBuffer r_indices$3;
            private final ArrayBuffer r_values$3;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                int sv2_idx = this.sv2$1.indices()[i];
                if (package.abs$.MODULE$.apply$mDDc$sp(this.v1$1.apply(i), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$) > 1.0E-7) {
                    this.r_indices$3.$plus$eq((Object)BoxesRunTime.boxToInteger((int)sv2_idx));
                    boxedUnit = this.r_values$3.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(this.v1$1.apply(sv2_idx) * this.sv2$1.values()[i])));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.v1$1 = v1$1;
                this.sv2$1 = sv2$1;
                this.r_indices$3 = r_indices$3;
                this.r_values$3 = r_values$3;
            }
        });
        return (SparseVector)Vectors$.MODULE$.sparse(sv2.size(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseVector multiply(SparseVector sv1, SparseVector sv2) {
        if (sv1.size() != sv2.size()) {
            throw new Exception("add error ,params valid sv1.size != sv2.size");
        }
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        int i = 0;
        int j = 0;
        while (i < sv1.indices().length && j < sv2.indices().length) {
            int sv2_idx;
            int sv1_idx = sv1.indices()[i];
            if (sv1_idx < (sv2_idx = sv2.indices()[j])) {
                ++i;
            }
            if (sv1_idx > sv2_idx) {
                ++j;
            }
            if (sv1_idx != sv2_idx) continue;
            r_indices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)sv1_idx));
            r_values.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(sv1.values()[i] * sv2.values()[j])));
            ++i;
            ++j;
        }
        return (SparseVector)Vectors$.MODULE$.sparse(sv1.size(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix multiply(SparseVector sv1, int copy_nums, Matrix sm2) {
        if (sv1.size() != sm2.numRows() || copy_nums != sm2.numCols()) {
            throw new Exception("multiply error ,params valid sm1.numRows!=sm2.numRows || sm1.numCols!=sm2.numCols");
        }
        int sv1_indices_length = sv1.indices().length;
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm2.numCols() - 1).foreach((Function1)new Serializable(sv1, sm2, sv1_indices_length, ret_colPtrs, ret_rowIndices, ret_values){
            public static final long serialVersionUID = 0L;
            public final SparseVector sv1$1;
            public final Matrix sm2$1;
            private final int sv1_indices_length$1;
            private final ArrayBuffer ret_colPtrs$4;
            private final ArrayBuffer ret_rowIndices$7;
            private final ArrayBuffer ret_values$4;

            public final ArrayBuffer<Object> apply(int i) {
                ArrayBuffer sub_indices = new ArrayBuffer();
                ArrayBuffer sub_values = new ArrayBuffer();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.sv1_indices_length$1 - 1).foreach((Function1)new Serializable(this, i, sub_indices, sub_values){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.multiply.2 $outer;
                    private final int i$1;
                    private final ArrayBuffer sub_indices$1;
                    private final ArrayBuffer sub_values$1;

                    public final Object apply(int j) {
                        BoxedUnit boxedUnit;
                        int sv1_i = this.$outer.sv1$1.indices()[j];
                        double sm2_v = this.$outer.sm2$1.apply(sv1_i, this.i$1);
                        if (sm2_v > 0.0 || sm2_v < 0.0) {
                            this.sub_indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)sv1_i));
                            boxedUnit = this.sub_values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)(this.$outer.sv1$1.values()[j] * sm2_v)));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                        this.sub_indices$1 = sub_indices$1;
                        this.sub_values$1 = sub_values$1;
                    }
                });
                this.ret_rowIndices$7.$plus$plus$eq((TraversableOnce)sub_indices);
                this.ret_values$4.$plus$plus$eq((TraversableOnce)sub_values);
                return this.ret_colPtrs$4.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.ret_colPtrs$4.apply(i)) + sub_indices.length())));
            }
            {
                this.sv1$1 = sv1$1;
                this.sm2$1 = sm2$1;
                this.sv1_indices_length$1 = sv1_indices_length$1;
                this.ret_colPtrs$4 = ret_colPtrs$4;
                this.ret_rowIndices$7 = ret_rowIndices$7;
                this.ret_values$4 = ret_values$4;
            }
        });
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm2.numRows(), sm2.numCols(), (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix multiply(SparseMatrix sm1_o, SparseMatrix sm2_o) {
        if (sm1_o.numRows() != sm2_o.numRows() || sm1_o.numCols() != sm2_o.numCols()) {
            throw new Exception("multiply error ,params valid sm1.numRows!=sm2.numRows || sm1.numCols!=sm2.numCols");
        }
        SparseMatrix sm1 = this.transposeClean(sm1_o);
        SparseMatrix sm2 = this.transposeClean(sm2_o);
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach((Function1)new Serializable(sm1, sm2, ret_colPtrs, ret_rowIndices, ret_values){
            public static final long serialVersionUID = 0L;
            private final SparseMatrix sm1$4;
            private final SparseMatrix sm2$3;
            private final ArrayBuffer ret_colPtrs$5;
            private final ArrayBuffer ret_rowIndices$8;
            private final ArrayBuffer ret_values$5;

            public final ArrayBuffer<Object> apply(int i) {
                int[] p1_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm1$4.rowIndices()).slice(this.sm1$4.colPtrs()[i], this.sm1$4.colPtrs()[i + 1]);
                double[] p1_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm1$4.values()).slice(this.sm1$4.colPtrs()[i], this.sm1$4.colPtrs()[i + 1]);
                SparseVector p1_Vector = (SparseVector)Vectors$.MODULE$.sparse(this.sm1$4.numRows(), p1_indices, p1_values);
                int[] p2_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm2$3.rowIndices()).slice(this.sm2$3.colPtrs()[i], this.sm2$3.colPtrs()[i + 1]);
                double[] p2_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm2$3.values()).slice(this.sm2$3.colPtrs()[i], this.sm2$3.colPtrs()[i + 1]);
                SparseVector p2_Vector = (SparseVector)Vectors$.MODULE$.sparse(this.sm2$3.numRows(), p2_indices, p2_values);
                SparseVector p_Vector = SparseUtil$.MODULE$.multiply(p1_Vector, p2_Vector);
                this.ret_rowIndices$8.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(p_Vector.indices()));
                this.ret_values$5.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(p_Vector.values()));
                return this.ret_colPtrs$5.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.ret_colPtrs$5.apply(i)) + p_Vector.indices().length)));
            }
            {
                this.sm1$4 = sm1$4;
                this.sm2$3 = sm2$3;
                this.ret_colPtrs$5 = ret_colPtrs$5;
                this.ret_rowIndices$8 = ret_rowIndices$8;
                this.ret_values$5 = ret_values$5;
            }
        });
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm1.numRows(), sm1.numCols(), (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseVector multiply(SparseVector sv) {
        return (SparseVector)Vectors$.MODULE$.sparse(sv.size(), sv.indices(), (double[])Predef$.MODULE$.doubleArrayOps(sv.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i * i;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    public SparseMatrix multiply(SparseMatrix sm_o) {
        SparseMatrix sm = this.transposeClean(sm_o);
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sm.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i * i;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm.numRows(), sm.numCols(), sm.colPtrs(), sm.rowIndices(), m_values);
    }

    public SparseVector dot_col(SparseMatrix sparseMatrix, SparseVector sparseVector) {
        if (sparseMatrix.numCols() != sparseVector.size()) {
            throw new Exception("dot_col error ,params valid sparseMatrix.numRows != sparseVector.size");
        }
        return this.dot_row(sparseMatrix.transpose(), sparseVector);
    }

    public SparseVector dot_row(SparseMatrix sparseMatrix_o, SparseVector sparseVector) {
        if (sparseMatrix_o.numRows() != sparseVector.size()) {
            throw new Exception("dot_row error ,params valid sparseMatrix.numRows != sparseVector.size");
        }
        SparseMatrix sparseMatrix = this.transposeClean(sparseMatrix_o);
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sparseMatrix.numCols() - 1).foreach((Function1)new Serializable(sparseVector, sparseMatrix, r_indices, r_values){
            public static final long serialVersionUID = 0L;
            private final SparseVector sparseVector$2;
            private final SparseMatrix sparseMatrix$1;
            private final ArrayBuffer r_indices$4;
            private final ArrayBuffer r_values$4;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                int offset_start = this.sparseMatrix$1.colPtrs()[i];
                int offset_end = this.sparseMatrix$1.colPtrs()[i + 1];
                int[] p_indices = (int[])Predef$.MODULE$.intArrayOps(this.sparseMatrix$1.rowIndices()).slice(offset_start, offset_end);
                double[] p_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sparseMatrix$1.values()).slice(offset_start, offset_end);
                SparseVector pVector = (SparseVector)Vectors$.MODULE$.sparse(this.sparseMatrix$1.numRows(), p_indices, p_values);
                double d_value = SparseUtil$.MODULE$.dot(pVector, this.sparseVector$2);
                if (package.abs$.MODULE$.apply$mDDc$sp(d_value - 0.0, (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$) > 1.0E-6) {
                    this.r_indices$4.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = this.r_values$4.$plus$eq((Object)BoxesRunTime.boxToDouble((double)d_value));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.sparseVector$2 = sparseVector$2;
                this.sparseMatrix$1 = sparseMatrix$1;
                this.r_indices$4 = r_indices$4;
                this.r_values$4 = r_values$4;
            }
        });
        return (SparseVector)Vectors$.MODULE$.sparse(sparseMatrix.numCols(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseVector dot_row(Matrix matrix, SparseVector sparseVector) {
        if (matrix.numRows() != sparseVector.size()) {
            throw new Exception("dot_row error ,params valid sparseMatrix.numRows != sparseVector.size");
        }
        ArrayBuffer r_indices = new ArrayBuffer();
        ArrayBuffer r_values = new ArrayBuffer();
        int sparse_idx_length = sparseVector.indices().length;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), matrix.numCols() - 1).foreach((Function1)new Serializable(matrix, sparseVector, r_indices, r_values, sparse_idx_length){
            public static final long serialVersionUID = 0L;
            public final Matrix matrix$1;
            public final SparseVector sparseVector$1;
            private final ArrayBuffer r_indices$5;
            private final ArrayBuffer r_values$5;
            private final int sparse_idx_length$1;

            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                DoubleRef d_value = new DoubleRef(0.0);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.sparse_idx_length$1 - 1).foreach$mVc$sp((Function1)new Serializable(this, i, d_value){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.dot_row.2 $outer;
                    private final int i$2;
                    private final DoubleRef d_value$1;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        int s_idx = this.$outer.sparseVector$1.indices()[j];
                        double m_v = this.$outer.matrix$1.apply(s_idx, this.i$2);
                        if (package.abs$.MODULE$.apply$mDDc$sp(m_v - 0.0, (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$) > 1.0E-6) {
                            this.d_value$1.elem += this.$outer.sparseVector$1.values()[j] * m_v;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                        this.d_value$1 = d_value$1;
                    }
                });
                if (package.abs$.MODULE$.apply$mDDc$sp(d_value.elem - 0.0, (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$) > 1.0E-6) {
                    this.r_indices$5.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                    boxedUnit = this.r_values$5.$plus$eq((Object)BoxesRunTime.boxToDouble((double)d_value.elem));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.matrix$1 = matrix$1;
                this.sparseVector$1 = sparseVector$1;
                this.r_indices$5 = r_indices$5;
                this.r_values$5 = r_values$5;
                this.sparse_idx_length$1 = sparse_idx_length$1;
            }
        });
        return (SparseVector)Vectors$.MODULE$.sparse(matrix.numCols(), (int[])r_indices.toArray(ClassTag$.MODULE$.Int()), (double[])r_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix dot(SparseMatrix sm1, SparseMatrix sm2) {
        if (sm1.numCols() != sm2.numRows()) {
            throw new Exception("dot error ,params valid sm1.numRows != sm2.numCols || sm1.numCols != sm2.numRows");
        }
        return this.dot_r_r(sm2, sm1.transpose());
    }

    public SparseMatrix dot_r_r(SparseMatrix sm1_o, SparseMatrix sm2_o) {
        if (sm1_o.numRows() != sm2_o.numRows()) {
            throw new Exception("dot_r_r error ,params valid sparseMatrix.numRows != sparseVector.size");
        }
        SparseMatrix sm1 = this.transposeClean(sm1_o);
        SparseMatrix sm2 = this.transposeClean(sm2_o);
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        SparseVector[] lVectorArray = new SparseVector[sm1.numCols()];
        SparseVector[] rVectorArray = new SparseVector[sm2.numCols()];
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach$mVc$sp((Function1)new Serializable(sm1, lVectorArray){
            public static final long serialVersionUID = 0L;
            private final SparseMatrix sm1$5;
            private final SparseVector[] lVectorArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                SparseVector l_vector;
                int[] l_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm1$5.rowIndices()).slice(this.sm1$5.colPtrs()[i], this.sm1$5.colPtrs()[i + 1]);
                double[] l_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm1$5.values()).slice(this.sm1$5.colPtrs()[i], this.sm1$5.colPtrs()[i + 1]);
                this.lVectorArray$1[i] = l_vector = (SparseVector)Vectors$.MODULE$.sparse(this.sm1$5.numRows(), l_indices, l_values);
            }
            {
                this.sm1$5 = sm1$5;
                this.lVectorArray$1 = lVectorArray$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm2.numCols() - 1).foreach$mVc$sp((Function1)new Serializable(sm2, rVectorArray){
            public static final long serialVersionUID = 0L;
            private final SparseMatrix sm2$4;
            private final SparseVector[] rVectorArray$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                SparseVector r_vector;
                int[] r_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm2$4.rowIndices()).slice(this.sm2$4.colPtrs()[j], this.sm2$4.colPtrs()[j + 1]);
                double[] r_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm2$4.values()).slice(this.sm2$4.colPtrs()[j], this.sm2$4.colPtrs()[j + 1]);
                this.rVectorArray$1[j] = r_vector = (SparseVector)Vectors$.MODULE$.sparse(this.sm2$4.numRows(), r_indices, r_values);
            }
            {
                this.sm2$4 = sm2$4;
                this.rVectorArray$1 = rVectorArray$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach((Function1)new Serializable(sm2, ret_colPtrs, ret_rowIndices, ret_values, lVectorArray, rVectorArray){
            public static final long serialVersionUID = 0L;
            private final SparseMatrix sm2$4;
            private final ArrayBuffer ret_colPtrs$6;
            private final ArrayBuffer ret_rowIndices$9;
            private final ArrayBuffer ret_values$6;
            private final SparseVector[] lVectorArray$1;
            public final SparseVector[] rVectorArray$1;

            public final ArrayBuffer<Object> apply(int i) {
                SparseVector l_vector = this.lVectorArray$1[i];
                ArrayBuffer rv_indices = new ArrayBuffer();
                ArrayBuffer rv_values = new ArrayBuffer();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.sm2$4.numCols() - 1).foreach((Function1)new Serializable(this, l_vector, rv_indices, rv_values){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.dot_r_r.3 $outer;
                    private final SparseVector l_vector$1;
                    private final ArrayBuffer rv_indices$1;
                    private final ArrayBuffer rv_values$1;

                    public final Object apply(int j) {
                        BoxedUnit boxedUnit;
                        SparseVector r_vector = this.$outer.rVectorArray$1[j];
                        double l_r_dot = SparseUtil$.MODULE$.dot(this.l_vector$1, r_vector);
                        if (Math.abs(l_r_dot) > GlobalConstant.DOUBLE_ZERO) {
                            this.rv_indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)j));
                            boxedUnit = this.rv_values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)l_r_dot));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.l_vector$1 = l_vector$1;
                        this.rv_indices$1 = rv_indices$1;
                        this.rv_values$1 = rv_values$1;
                    }
                });
                this.ret_rowIndices$9.$plus$plus$eq((TraversableOnce)rv_indices);
                this.ret_values$6.$plus$plus$eq((TraversableOnce)rv_values);
                return this.ret_colPtrs$6.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.ret_colPtrs$6.apply(i)) + rv_indices.length())));
            }
            {
                this.sm2$4 = sm2$4;
                this.ret_colPtrs$6 = ret_colPtrs$6;
                this.ret_rowIndices$9 = ret_rowIndices$9;
                this.ret_values$6 = ret_values$6;
                this.lVectorArray$1 = lVectorArray$1;
                this.rVectorArray$1 = rVectorArray$1;
            }
        });
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm2.numCols(), sm1.numCols(), (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix dot_r_r2(SparseMatrix sm1_o, SparseMatrix sm2_o) {
        if (sm1_o.numRows() != sm2_o.numRows()) {
            throw new Exception("dot_r_r error ,params valid sparseMatrix.numRows != sparseVector.size");
        }
        SparseMatrix sm1 = this.transposeClean(sm1_o);
        SparseMatrix sm2 = this.transposeClean(sm2_o);
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach((Function1)new Serializable(sm1, sm2, ret_colPtrs, ret_rowIndices, ret_values){
            public static final long serialVersionUID = 0L;
            private final SparseMatrix sm1$6;
            public final SparseMatrix sm2$5;
            private final ArrayBuffer ret_colPtrs$7;
            private final ArrayBuffer ret_rowIndices$10;
            private final ArrayBuffer ret_values$7;

            public final ArrayBuffer<Object> apply(int i) {
                int[] l_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm1$6.rowIndices()).slice(this.sm1$6.colPtrs()[i], this.sm1$6.colPtrs()[i + 1]);
                double[] l_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm1$6.values()).slice(this.sm1$6.colPtrs()[i], this.sm1$6.colPtrs()[i + 1]);
                SparseVector l_vector = (SparseVector)Vectors$.MODULE$.sparse(this.sm1$6.numRows(), l_indices, l_values);
                ArrayBuffer rv_indices = new ArrayBuffer();
                ArrayBuffer rv_values = new ArrayBuffer();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.sm2$5.numCols() - 1).foreach((Function1)new Serializable(this, l_vector, rv_indices, rv_values){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.dot_r_r2.1 $outer;
                    private final SparseVector l_vector$2;
                    private final ArrayBuffer rv_indices$2;
                    private final ArrayBuffer rv_values$2;

                    public final Object apply(int j) {
                        BoxedUnit boxedUnit;
                        int[] r_indices = (int[])Predef$.MODULE$.intArrayOps(this.$outer.sm2$5.rowIndices()).slice(this.$outer.sm2$5.colPtrs()[j], this.$outer.sm2$5.colPtrs()[j + 1]);
                        double[] r_values = (double[])Predef$.MODULE$.doubleArrayOps(this.$outer.sm2$5.values()).slice(this.$outer.sm2$5.colPtrs()[j], this.$outer.sm2$5.colPtrs()[j + 1]);
                        SparseVector r_vector = (SparseVector)Vectors$.MODULE$.sparse(this.$outer.sm2$5.numRows(), r_indices, r_values);
                        double l_r_dot = SparseUtil$.MODULE$.dot(this.l_vector$2, r_vector);
                        if (Math.abs(l_r_dot) > GlobalConstant.DOUBLE_ZERO) {
                            this.rv_indices$2.$plus$eq((Object)BoxesRunTime.boxToInteger((int)j));
                            boxedUnit = this.rv_values$2.$plus$eq((Object)BoxesRunTime.boxToDouble((double)l_r_dot));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.l_vector$2 = l_vector$2;
                        this.rv_indices$2 = rv_indices$2;
                        this.rv_values$2 = rv_values$2;
                    }
                });
                this.ret_rowIndices$10.$plus$plus$eq((TraversableOnce)rv_indices);
                this.ret_values$7.$plus$plus$eq((TraversableOnce)rv_values);
                return this.ret_colPtrs$7.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.ret_colPtrs$7.apply(i)) + rv_indices.length())));
            }
            {
                this.sm1$6 = sm1$6;
                this.sm2$5 = sm2$5;
                this.ret_colPtrs$7 = ret_colPtrs$7;
                this.ret_rowIndices$10 = ret_rowIndices$10;
                this.ret_values$7 = ret_values$7;
            }
        });
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm2.numCols(), sm1.numCols(), (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
    }

    public SparseMatrix dot_m(SparseVector sv1, SparseVector sv2) {
        ArrayBuffer ret_colPtrs = new ArrayBuffer();
        ArrayBuffer ret_rowIndices = new ArrayBuffer();
        ArrayBuffer ret_values = new ArrayBuffer();
        ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        IntRef last_colPtrs = new IntRef(0);
        IntRef idx_o = new IntRef(-1);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sv2.indices().length - 1).foreach$mVc$sp((Function1)new Serializable(sv1, sv2, ret_colPtrs, ret_rowIndices, ret_values, last_colPtrs, idx_o){
            public static final long serialVersionUID = 0L;
            private final SparseVector sv1$4;
            private final SparseVector sv2$2;
            public final ArrayBuffer ret_colPtrs$8;
            private final ArrayBuffer ret_rowIndices$11;
            private final ArrayBuffer ret_values$8;
            public final IntRef last_colPtrs$1;
            private final IntRef idx_o$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx_n = this.sv2$2.indices()[i];
                double v_i = this.sv2$2.values()[i];
                this.ret_rowIndices$11.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps(this.sv1$4.indices()));
                this.ret_values$8.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.doubleArrayOps(this.sv1$4.values()).map((Function1)new Serializable(this, v_i){
                    public static final long serialVersionUID = 0L;
                    private final double v_i$1;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x * this.v_i$1;
                    }
                    {
                        this.v_i$1 = v_i$1;
                    }
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), idx_n - this.idx_o$1.elem - 2).foreach$mVc$sp((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.dot_m.1 $outer;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.ret_colPtrs$8.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.$outer.last_colPtrs$1.elem));
                        this.$outer.last_colPtrs$1.elem += 0;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.last_colPtrs$1.elem += this.sv1$4.indices().length;
                this.ret_colPtrs$8.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.last_colPtrs$1.elem));
                this.idx_o$1.elem = idx_n;
            }
            {
                this.sv1$4 = sv1$4;
                this.sv2$2 = sv2$2;
                this.ret_colPtrs$8 = ret_colPtrs$8;
                this.ret_rowIndices$11 = ret_rowIndices$11;
                this.ret_values$8 = ret_values$8;
                this.last_colPtrs$1 = last_colPtrs$1;
                this.idx_o$1 = idx_o$1;
            }
        });
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sv2.size() - idx_o.elem - 2).foreach((Function1)new Serializable(ret_colPtrs, last_colPtrs){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer ret_colPtrs$8;
            private final IntRef last_colPtrs$1;

            public final ArrayBuffer<Object> apply(int j) {
                return this.ret_colPtrs$8.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.last_colPtrs$1.elem));
            }
            {
                this.ret_colPtrs$8 = ret_colPtrs$8;
                this.last_colPtrs$1 = last_colPtrs$1;
            }
        });
        return (SparseMatrix)Matrices$.MODULE$.sparse(sv1.size(), sv2.size(), (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
    }

    /*
     * WARNING - void declaration
     */
    public double dot(SparseVector sv1, SparseVector sv2) {
        void var3_3;
        if (sv1.size() != sv2.size()) {
            throw new Exception("v_dot error ,params valid sv1.size != sv2.size");
        }
        double d_sum = 0.0;
        int i = 0;
        int j = 0;
        int sv1_idx = sv1.indices().length;
        int sv2_idx = sv2.indices().length;
        while (i < sv1_idx && j < sv2_idx) {
            int sv2_idx2;
            int sv1_idx2 = sv1.indices()[i];
            if (sv1_idx2 < (sv2_idx2 = sv2.indices()[j])) {
                ++i;
            }
            if (sv1_idx2 > sv2_idx2) {
                ++j;
            }
            if (sv1_idx2 != sv2_idx2) continue;
            d_sum += sv1.values()[i] * sv2.values()[j];
            ++i;
            ++j;
        }
        return (double)var3_3;
    }

    public double dot3(SparseVector sv2, Vector v1) {
        if (v1.size() != sv2.size()) {
            throw new Exception("v_dot error ,params valid sv1.size != sv2.size");
        }
        DoubleRef d_sum = new DoubleRef(0.0);
        int sv2_idx_length = sv2.indices().length;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sv2_idx_length - 1).foreach$mVc$sp((Function1)new Serializable(sv2, v1, d_sum){
            public static final long serialVersionUID = 0L;
            private final SparseVector sv2$3;
            private final Vector v1$2;
            private final DoubleRef d_sum$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx = this.sv2$3.indices()[i];
                this.d_sum$1.elem += this.sv2$3.values()[i] * this.v1$2.apply(idx);
            }
            {
                this.sv2$3 = sv2$3;
                this.v1$2 = v1$2;
                this.d_sum$1 = d_sum$1;
            }
        });
        return d_sum.elem;
    }

    /*
     * WARNING - void declaration
     */
    public double dot2(SparseVector sv1, SparseVector sv2) {
        void var3_3;
        if (sv1.size() != sv2.size()) {
            throw new Exception("v_dot error ,params valid sv1.size != sv2.size");
        }
        double d_sum = 0.0;
        if (sv1.indices().length != 0 && sv2.indices().length != 0) {
            d_sum = sv1.indices().length <= sv2.indices().length ? this.dot_v_sv((Vector)sv2, sv1) : this.dot_v_sv((Vector)sv1, sv2);
        }
        return (double)var3_3;
    }

    public double dot_v_sv(Vector v1, SparseVector sv2) {
        if (v1.size() != sv2.size()) {
            throw new Exception("v_dot error ,params valid sv1.size != sv2.size");
        }
        DoubleRef d_sum = new DoubleRef(0.0);
        int sv2_idx_length = sv2.indices().length;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sv2_idx_length - 1).foreach$mVc$sp((Function1)new Serializable(v1, sv2, d_sum){
            public static final long serialVersionUID = 0L;
            private final Vector v1$3;
            private final SparseVector sv2$4;
            private final DoubleRef d_sum$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx = this.sv2$4.indices()[i];
                this.d_sum$2.elem += this.sv2$4.values()[i] * this.v1$3.apply(idx);
            }
            {
                this.v1$3 = v1$3;
                this.sv2$4 = sv2$4;
                this.d_sum$2 = d_sum$2;
            }
        });
        return d_sum.elem;
    }

    public SparseVector subtraction(SparseVector sv1, SparseVector sv2) {
        if (sv1.size() != sv2.size()) {
            throw new Exception("subtraction error ,params valid sv1.size != sv2.size");
        }
        SparseVector sv2_f = (SparseVector)Vectors$.MODULE$.sparse(sv2.size(), sv2.indices(), (double[])Predef$.MODULE$.doubleArrayOps(sv2.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return -x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        return this.add(sv1, sv2_f);
    }

    public SparseMatrix subtraction(SparseMatrix sm1, SparseMatrix sm2) {
        if (sm1.numRows() != sm2.numRows() || sm1.numCols() != sm2.numCols()) {
            throw new Exception("subtraction error ,params valid sm1.numRows!=sm2.numRows || sm1.numCols!=sm2.numCols");
        }
        SparseMatrix sm2_f = (SparseMatrix)Matrices$.MODULE$.sparse(sm2.numRows(), sm2.numCols(), (int[])Predef$.MODULE$.intArrayOps(sm2.colPtrs()).toArray(ClassTag$.MODULE$.Int()), sm2.rowIndices(), (double[])Predef$.MODULE$.doubleArrayOps(sm2.values()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$2) {
                return this.apply$mcDD$sp(x$2);
            }

            public double apply$mcDD$sp(double x$2) {
                return -x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        return this.add(sm1, sm2_f);
    }

    public SparseVector subtraction(SparseVector sv, double d) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sv.values()).map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final double d$6;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i - this.d$6;
            }
            {
                this.d$6 = d$6;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseVector)Vectors$.MODULE$.sparse(sv.size(), sv.indices(), m_values);
    }

    public SparseMatrix subtraction(SparseMatrix sm, double d) {
        double[] m_values = (double[])Predef$.MODULE$.doubleArrayOps(sm.values()).map((Function1)new Serializable(d){
            public static final long serialVersionUID = 0L;
            private final double d$5;

            public final double apply(double i) {
                return this.apply$mcDD$sp(i);
            }

            public double apply$mcDD$sp(double i) {
                return i - this.d$5;
            }
            {
                this.d$5 = d$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return (SparseMatrix)Matrices$.MODULE$.sparse(sm.numRows(), sm.numCols(), sm.colPtrs(), sm.rowIndices(), m_values);
    }

    public SparseMatrix transposeClean(SparseMatrix sm) {
        SparseMatrix sparseMatrix;
        if (sm.isTransposed()) {
            SparseMatrix sm1 = sm.transpose();
            ArrayBuffer ret_colPtrs = new ArrayBuffer();
            ArrayBuffer ret_rowIndices = new ArrayBuffer();
            ArrayBuffer ret_values = new ArrayBuffer();
            ArrayBuffer[] rowIndices_list = new ArrayBuffer[sm1.numRows()];
            ArrayBuffer[] values_list = new ArrayBuffer[sm1.numRows()];
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numRows() - 1).foreach$mVc$sp((Function1)new Serializable(rowIndices_list, values_list){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer[] rowIndices_list$1;
                private final ArrayBuffer[] values_list$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.rowIndices_list$1[i] = new ArrayBuffer();
                    this.values_list$1[i] = new ArrayBuffer();
                }
                {
                    this.rowIndices_list$1 = rowIndices_list$1;
                    this.values_list$1 = values_list$1;
                }
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numCols() - 1).foreach$mVc$sp((Function1)new Serializable(sm1, rowIndices_list, values_list){
                public static final long serialVersionUID = 0L;
                private final SparseMatrix sm1$7;
                private final ArrayBuffer[] rowIndices_list$1;
                private final ArrayBuffer[] values_list$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    int[] o_indices = (int[])Predef$.MODULE$.intArrayOps(this.sm1$7.rowIndices()).slice(this.sm1$7.colPtrs()[i], this.sm1$7.colPtrs()[i + 1]);
                    double[] o_values = (double[])Predef$.MODULE$.doubleArrayOps(this.sm1$7.values()).slice(this.sm1$7.colPtrs()[i], this.sm1$7.colPtrs()[i + 1]);
                    for (int j = 0; j < o_indices.length; ++j) {
                        int idx = o_indices[j];
                        this.rowIndices_list$1[idx].$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                        this.values_list$1[idx].$plus$eq((Object)BoxesRunTime.boxToDouble((double)o_values[j]));
                    }
                }
                {
                    this.sm1$7 = sm1$7;
                    this.rowIndices_list$1 = rowIndices_list$1;
                    this.values_list$1 = values_list$1;
                }
            });
            IntRef offSet = new IntRef(0);
            ret_colPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sm1.numRows() - 1).foreach((Function1)new Serializable(ret_colPtrs, ret_rowIndices, ret_values, rowIndices_list, values_list, offSet){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer ret_colPtrs$9;
                private final ArrayBuffer ret_rowIndices$12;
                private final ArrayBuffer ret_values$9;
                private final ArrayBuffer[] rowIndices_list$1;
                private final ArrayBuffer[] values_list$1;
                private final IntRef offSet$1;

                public final ArrayBuffer<Object> apply(int i) {
                    this.ret_rowIndices$12.$plus$plus$eq((TraversableOnce)this.rowIndices_list$1[i]);
                    this.ret_values$9.$plus$plus$eq((TraversableOnce)this.values_list$1[i]);
                    this.offSet$1.elem += this.rowIndices_list$1[i].length();
                    return this.ret_colPtrs$9.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.offSet$1.elem));
                }
                {
                    this.ret_colPtrs$9 = ret_colPtrs$9;
                    this.ret_rowIndices$12 = ret_rowIndices$12;
                    this.ret_values$9 = ret_values$9;
                    this.rowIndices_list$1 = rowIndices_list$1;
                    this.values_list$1 = values_list$1;
                    this.offSet$1 = offSet$1;
                }
            });
            sparseMatrix = (SparseMatrix)Matrices$.MODULE$.sparse(sm1.numCols(), sm1.numRows(), (int[])ret_colPtrs.toArray(ClassTag$.MODULE$.Int()), (int[])ret_rowIndices.toArray(ClassTag$.MODULE$.Int()), (double[])ret_values.toArray(ClassTag$.MODULE$.Double()));
        } else {
            sparseMatrix = sm;
        }
        return sparseMatrix;
    }

    private SparseUtil$() {
        MODULE$ = this;
    }
}

