/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.compute.mllib.evaluater;

import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd$;

public final class ClassifierEvaluater$ {
    public static final ClassifierEvaluater$ MODULE$;

    static {
        new ClassifierEvaluater$();
    }

    public void calMulticlassMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels, double threshold) {
        RDD pAndLables = predictionAndLabels.map((Function1)new Serializable(threshold){
            public static final long serialVersionUID = 0L;
            private final double threshold$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double pre = tuple2._1$mcD$sp();
                    double lable = tuple2._2$mcD$sp();
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(pre > this.threshold$1 ? 1.0 : 0.0, lable);
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.threshold$1 = threshold$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        MulticlassMetrics metrics = new MulticlassMetrics(pAndLables);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Performance with threshold : --- ", " ---"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)threshold)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"matrix = \\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metrics.confusionMatrix()})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recall(1.0) = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.recall(1.0))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"precision(1.0) = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.precision(1.0))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recall(0.0) = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.recall(0.0))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"precision(0.0) = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)metrics.precision(0.0))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"f1 = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.fScore(metrics.recall(1.0), metrics.precision(1.0), 1.0))})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})).s((Seq)Nil$.MODULE$));
    }

    public void showPredictionAndLabels(RDD<Tuple3<List<String>, Object, Object>> predictionAndLabels) {
        long num = predictionAndLabels.count();
        Predef$.MODULE$.refArrayOps((Object[])predictionAndLabels.sample(false, Math.min(1.0, (double)Math.round(100L / num)), 0L).collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple3<List<String>, Object, Object> x) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(x._1()), ":")).append(x._2()).append((Object)"-->").append(x._3()).toString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
    }

    public void precisionByThreshold(BinaryClassificationMetrics metrics) {
        RDD precision = metrics.precisionByThreshold();
        long precisionNum = precision.count();
        precision.sample(false, Math.min(1.0, (double)Math.round(100L / precisionNum)), 0L).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    double t = tuple2._1$mcD$sp();
                    double r = tuple2._2$mcD$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", Precision: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)r)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void recallByThreshold(BinaryClassificationMetrics metrics) {
        RDD recall = metrics.recallByThreshold();
        long recallNum = recall.count();
        recall.sample(false, Math.min(1.0, (double)Math.round(100L / recallNum)), 0L).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    double t = tuple2._1$mcD$sp();
                    double r = tuple2._2$mcD$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", Recall: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)r)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void fMeasureByThreshold(BinaryClassificationMetrics metrics) {
        RDD f1Score = metrics.fMeasureByThreshold();
        long f1ScoreNum = f1Score.count();
        f1Score.sample(false, Math.min(1.0, (double)Math.round(100L / f1ScoreNum)), 0L).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$4) {
                Tuple2<Object, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    double t = tuple2._1$mcD$sp();
                    double f = tuple2._2$mcD$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", F-score: ", ", Beta = 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)f)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        double beta = 0.5;
        RDD fScore = metrics.fMeasureByThreshold(beta);
        long fScoreNum = fScore.count();
        fScore.sample(false, Math.min(1.0, (double)Math.round(100L / fScoreNum)), 0L).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$5) {
                Tuple2<Object, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    double t = tuple2._1$mcD$sp();
                    double f = tuple2._2$mcD$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold: ", ", F-score: ", ", Beta = 0.5"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)t), BoxesRunTime.boxToDouble((double)f)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public double calAuPRC(BinaryClassificationMetrics metrics) {
        void var3_3;
        RDD PRC = metrics.pr();
        double auPRC = metrics.areaUnderPR();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under precision-recall curve = ").append((Object)BoxesRunTime.boxToDouble((double)auPRC)).toString());
        return (double)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public double calAuROC(BinaryClassificationMetrics metrics) {
        void var3_3;
        RDD ROC = metrics.roc();
        double auROC = metrics.areaUnderROC();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Area under ROC = ").append((Object)BoxesRunTime.boxToDouble((double)auROC)).toString());
        return (double)var3_3;
    }

    public double fScore(double recall, double precision, double fID) {
        return (1.0 + fID * fID) * (recall * precision / (recall + precision));
    }

    public double signLabel(double w, double threshold) {
        return w >= threshold ? 1.0 : -1.0;
    }

    private ClassifierEvaluater$() {
        MODULE$ = this;
    }
}

