package cn.com.duiba.nezha.engine.api.dto;

import cn.com.duiba.nezha.engine.api.enums.WeakFilteType;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by lwj on 2016/8/30.
 * 请求广告结果
 */
public class AdvertNewDto implements Serializable {

    private static final long serialVersionUID = 523827427472072954L;
    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 广告出价
     */
    private Long fee;

    /**
     * 广告定向配置ID
     */
    private Long advertOrientationPackageId;

    /**
     * 对该用户的最近发放次数
     */
    private Long count;

    /**
     * 计费类型 1.CPC 2.CPA
     */
    private Integer chargeType;

    /**
     * 推广链接标签(已废弃)
     */
    private Set<Long> tags;

    /**
     * 推广链接标签
     */
    private Set<String> spreadTags;

    /**
     * 广告主账号
     */
    private String accountId;


    /**
     * 推广网址
     */
    private String promoteUrl;

    /**
     * 特征标签
     */
    private String matchTagNums;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 售卖价
     */
    private Long price;

    /**
     * 成本价
     */
    private Long cost;

    /**
     * 商品类目
     */
    private String catId;

    /**
     * 商品品牌
     */
    private String brandId;

    /**
     * 浏览量
     */
    private Long viewCount;

    /**
     * 售卖量
     */
    private Long buyCount;

    /**
     * 可用素材ID列表
     */
    private Set<Long> materialId;

    /**
     * 素材及其对应的标签列表(已废弃)
     */
    private Map<Long, Set<Long>> materialMap;

    /**
     * 素材及其对应的标签列表
     */
    private Map<Long, Set<String>> materialMapNew;

    /**
     * 标签权重
     */
    private Double weight;

    /**
     * 0点到当前每小时预算（不包括当前小时）
     */
    private List<Double>         hourlyBudgetFees;

    /**
     * 0点到当前每小时预算发券（不包括当前小时）
     */
    private List<Double>         hourlyBudgetCounts;

    /**
     * 定向配置总预算
     */
    private Long                 packageBudget;

    /**
     * 折扣率
     */
    private Double discountRate;

    /**
     * 行业标签
     */
    private String industryTag;

    /**
     * 行业标签(新)
     */
    private String industryTagNew;

    /**
     * 对应条件是否被弱过滤
     */
    private Map<WeakFilteType, Boolean> weakFilteMap;

    public AdvertNewDto(){}

    private AdvertNewDto(Builder builder) {
        setAdvertId(builder.advertId);
        setFee(builder.fee);
        setAdvertOrientationPackageId(builder.advertOrientationPackageId);
        setCount(builder.count);
        setChargeType(builder.chargeType);
        setTags(builder.tags);
        setSpreadTags(builder.spreadTags);
        setAccountId(builder.accountId);
        setPromoteUrl(builder.promoteUrl);
        setMatchTagNums(builder.matchTagNums);
        setGoodsId(builder.goodsId);
        setPrice(builder.price);
        setCost(builder.cost);
        setCatId(builder.catId);
        setBrandId(builder.brandId);
        setViewCount(builder.viewCount);
        setBuyCount(builder.buyCount);
        setMaterialId(builder.materialId);
        setMaterialMap(builder.materialMap);
        setMaterialMapNew(builder.materialMapNew);
        setWeight(builder.weight);
        setHourlyBudgetFees(builder.hourlyBudgetFees);
        setHourlyBudgetCounts(builder.hourlyBudgetCounts);
        setPackageBudget(builder.packageBudget);
        setDiscountRate(builder.discountRate);
        setIndustryTag(builder.industryTag);
        setIndustryTagNew(builder.industryTagNew);
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getAdvertOrientationPackageId() {
        return advertOrientationPackageId;
    }

    public void setAdvertOrientationPackageId(Long advertOrientationPackageId) {
        this.advertOrientationPackageId = advertOrientationPackageId;
    }

    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Set<Long> getTags() {
        return tags;
    }

    public void setTags(Set<Long> tags) {
        this.tags = tags;
    }

    public Set<String> getSpreadTags() {
        return spreadTags;
    }

    public void setSpreadTags(Set<String> spreadTags) {
        this.spreadTags = spreadTags;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public String getMatchTagNums() {
        return matchTagNums;
    }

    public void setMatchTagNums(String matchTagNums) {
        this.matchTagNums = matchTagNums;
    }

    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public Long getPrice() {
        return price;
    }

    public void setPrice(Long price) {
        this.price = price;
    }

    public Long getCost() {
        return cost;
    }

    public void setCost(Long cost) {
        this.cost = cost;
    }

    public String getCatId() {
        return catId;
    }

    public void setCatId(String catId) {
        this.catId = catId;
    }

    public String getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public Long getViewCount() {
        return viewCount;
    }

    public void setViewCount(Long viewCount) {
        this.viewCount = viewCount;
    }

    public Long getBuyCount() {
        return buyCount;
    }

    public void setBuyCount(Long buyCount) {
        this.buyCount = buyCount;
    }

    public Set<Long> getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Set<Long> materialId) {
        this.materialId = materialId;
    }

    public Map<Long, Set<Long>> getMaterialMap() {
        return materialMap;
    }

    public void setMaterialMap(Map<Long, Set<Long>> materialMap) {
        this.materialMap = materialMap;
    }

    public Map<Long, Set<String>> getMaterialMapNew() {
        return materialMapNew;
    }

    public void setMaterialMapNew(Map<Long, Set<String>> materialMapNew) {
        this.materialMapNew = materialMapNew;
    }

    public Double getWeight() {
        return weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public List<Double> getHourlyBudgetFees() {
        return hourlyBudgetFees;
    }

    public void setHourlyBudgetFees(List<Double> hourlyBudgetFees) {
        this.hourlyBudgetFees = hourlyBudgetFees;
    }

    public List<Double> getHourlyBudgetCounts() {
        return hourlyBudgetCounts;
    }

    public void setHourlyBudgetCounts(List<Double> hourlyBudgetCounts) {
        this.hourlyBudgetCounts = hourlyBudgetCounts;
    }

    public Long getPackageBudget() {
        return packageBudget;
    }

    public void setPackageBudget(Long packageBudget) {
        this.packageBudget = packageBudget;
    }

    public Double getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public String getIndustryTag() {
        return industryTag;
    }

    public void setIndustryTag(String industryTag) {
        this.industryTag = industryTag;
    }

    public String getIndustryTagNew() {
        return industryTagNew;
    }

    public void setIndustryTagNew(String industryTagNew) {
        this.industryTagNew = industryTagNew;
    }

    public Map<WeakFilteType, Boolean> getWeakFilteMap() {
        return weakFilteMap;
    }

    public void setWeakFilteMap(Map<WeakFilteType, Boolean> weakFilteMap) {
        this.weakFilteMap = weakFilteMap;
    }

    public static final class Builder {
        private Long advertId;
        private Long fee;
        private Long advertOrientationPackageId;
        private Long count;
        private Integer chargeType;
        private Set<Long> tags;
        private Set<String> spreadTags;
        private String accountId;
        private String promoteUrl;
        private String matchTagNums;
        private Long goodsId;
        private Long price;
        private Long cost;
        private String catId;
        private String brandId;
        private Long viewCount;
        private Long buyCount;
        private Set<Long> materialId;
        private Map<Long, Set<Long>> materialMap;
        private Map<Long, Set<String>> materialMapNew;
        private Double weight;
        private List<Double> hourlyBudgetFees;
        private List<Double> hourlyBudgetCounts;
        private Long packageBudget;
        private Double discountRate;
        private String industryTag;
        private String industryTagNew;

        public Builder() {
            //builder
        }

        public Builder advertId(Long val) {
            advertId = val;
            return this;
        }

        public Builder fee(Long val) {
            fee = val;
            return this;
        }

        public Builder advertOrientationPackageId(Long val) {
            advertOrientationPackageId = val;
            return this;
        }

        public Builder count(Long val) {
            count = val;
            return this;
        }

        public Builder chargeType(Integer val) {
            chargeType = val;
            return this;
        }

        public Builder tags(Set<Long> val) {
            tags = val;
            return this;
        }

        public Builder spreadTags(Set<String> val) {
            spreadTags = val;
            return this;
        }

        public Builder accountId(String val) {
            accountId = val;
            return this;
        }

        public Builder promoteUrl(String val) {
            promoteUrl = val;
            return this;
        }

        public Builder matchTagNums(String val) {
            matchTagNums = val;
            return this;
        }

        public Builder goodsId(Long val) {
            goodsId = val;
            return this;
        }

        public Builder price(Long val) {
            price = val;
            return this;
        }

        public Builder cost(Long val) {
            cost = val;
            return this;
        }

        public Builder catId(String val) {
            catId = val;
            return this;
        }

        public Builder brandId(String val) {
            brandId = val;
            return this;
        }

        public Builder viewCount(Long val) {
            viewCount = val;
            return this;
        }

        public Builder buyCount(Long val) {
            buyCount = val;
            return this;
        }

        public Builder materialId(Set<Long> val) {
            materialId = val;
            return this;
        }

        public Builder materialMap(Map<Long, Set<Long>> val) {
            materialMap = val;
            return this;
        }

        public Builder materialMapNew(Map<Long, Set<String>> val) {
            materialMapNew = val;
            return this;
        }

        public Builder weight(Double val) {
            weight = val;
            return this;
        }

        public Builder hourlyBudgetFees(List<Double> val) {
            hourlyBudgetFees = val;
            return this;
        }

        public Builder hourlyBudgetCounts(List<Double> val) {
            hourlyBudgetCounts = val;
            return this;
        }

        public Builder packageBudget(Long val) {
            packageBudget = val;
            return this;
        }

        public Builder discountRate(Double val) {
            discountRate = val;
            return this;
        }

        public Builder industryTag(String val) {
            industryTag = val;
            return this;
        }

        public Builder industryTagNew(String val) {
            industryTagNew = val;
            return this;
        }

        public AdvertNewDto build() {
            return new AdvertNewDto(this);
        }
    }
}
