/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.api.dto;

import cn.com.duiba.nezha.engine.api.dto.MaterialDto;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AdvertNewDto
implements Serializable {
    private static final long serialVersionUID = 523827427472072954L;
    private Long advertId;
    private Long packageId;
    private Integer packageType;
    private Integer targetAppLimit;
    private Boolean strongTarget;
    private Long fee;
    private Long launchCountToUser;
    private Integer chargeType;
    private Set<String> spreadTags;
    private String accountId;
    private String matchTagNums;
    private Set<MaterialDto> materials;
    private Map<Long, Set<String>> materialMapNew;
    private Double weight;
    private List<Double> hourlyBudgetFees;
    private List<Double> hourlyBudgetCounts;
    private Long packageBudget;
    private Double discountRate;
    private String industryTag;
    private String industryTagNew;
    private Long convertCost;
    private Long convertTypeCost;
    private Set<Long> backupAdvertIds;
    private Boolean supportStatus;
    private Boolean needSupportWeight;
    private Long assessCost;
    private Integer canReplaceLowArpu;
    private String newTradeTagNum;
    private String resourceTagNum;
    private Integer cvrType;
    private Integer depthCvrType;
    private Integer releaseTarget;
    private Long importantAppFee;
    private Integer budgetSmooth;

    private AdvertNewDto(Builder builder) {
        this.setAdvertId(builder.advertId);
        this.setPackageId(builder.packageId);
        this.setPackageType(builder.packageType);
        this.setTargetAppLimit(builder.targetAppLimit);
        this.setStrongTarget(builder.strongTarget);
        this.setFee(builder.fee);
        this.setLaunchCountToUser(builder.launchCountToUser);
        this.setChargeType(builder.chargeType);
        this.setSpreadTags(builder.spreadTags);
        this.setAccountId(builder.accountId);
        this.setMatchTagNums(builder.matchTagNums);
        this.setMaterials(builder.materials);
        this.setMaterialMapNew(builder.materialMapNew);
        this.setWeight(builder.weight);
        this.setHourlyBudgetFees(builder.hourlyBudgetFees);
        this.setHourlyBudgetCounts(builder.hourlyBudgetCounts);
        this.setPackageBudget(builder.packageBudget);
        this.setDiscountRate(builder.discountRate);
        this.setIndustryTag(builder.industryTag);
        this.setIndustryTagNew(builder.industryTagNew);
        this.setConvertCost(builder.convertCost);
        this.setConvertTypeCost(builder.convertTypeCost);
        this.setBackupAdvertIds(builder.backupAdvertIds);
        this.setSupportStatus(builder.supportStatus);
        this.setNeedSupportWeight(builder.needSupportWeight);
        this.setAssessCost(builder.assessCost);
        this.setNewTradeTagNum(builder.newTradeTagNum);
        this.setCvrType(builder.cvrType);
        this.setDepthCvrType(builder.depthCvrType);
        this.setBudgetSmooth(builder.budgetSmooth);
    }

    public Boolean getManuallyConvertCost() {
        return this.importantAppFee != null;
    }

    public Integer getDepthCvrType() {
        return this.depthCvrType;
    }

    public void setDepthCvrType(Integer depthCvrType) {
        this.depthCvrType = depthCvrType;
    }

    public Long getImportantAppFee() {
        return Optional.ofNullable(this.importantAppFee).orElse(this.getConvertCost());
    }

    public void setImportantAppFee(Long importantAppFee) {
        this.importantAppFee = importantAppFee;
    }

    public Integer getReleaseTarget() {
        return Optional.ofNullable(this.releaseTarget).orElse(3);
    }

    public void setReleaseTarget(Integer releaseTarget) {
        this.releaseTarget = releaseTarget;
    }

    public String getResourceTagNum() {
        return this.resourceTagNum;
    }

    public void setResourceTagNum(String resourceTagNum) {
        this.resourceTagNum = resourceTagNum;
    }

    public Integer getCvrType() {
        return Optional.ofNullable(this.cvrType).orElse(0);
    }

    public void setCvrType(Integer cvrType) {
        this.cvrType = cvrType;
    }

    public Long getAssessCost() {
        return this.assessCost;
    }

    public void setAssessCost(Long assessCost) {
        this.assessCost = assessCost;
    }

    public Boolean getSupportStatus() {
        return Optional.ofNullable(this.supportStatus).orElse(false);
    }

    public void setSupportStatus(Boolean supportStatus) {
        this.supportStatus = supportStatus;
    }

    public Boolean getNeedSupportWeight() {
        return Optional.ofNullable(this.needSupportWeight).orElse(false);
    }

    public void setNeedSupportWeight(Boolean needSupportWeight) {
        this.needSupportWeight = needSupportWeight;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Integer getPackageType() {
        return this.packageType;
    }

    public void setPackageType(Integer packageType) {
        this.packageType = packageType;
    }

    public Integer getTargetAppLimit() {
        return this.targetAppLimit;
    }

    public void setTargetAppLimit(Integer targetAppLimit) {
        this.targetAppLimit = targetAppLimit;
    }

    public Boolean getStrongTarget() {
        return Optional.ofNullable(this.strongTarget).orElse(false);
    }

    public void setStrongTarget(Boolean strongTarget) {
        this.strongTarget = strongTarget;
    }

    public Long getPackageId() {
        return this.packageId;
    }

    public Set<Long> getBackupAdvertIds() {
        return Optional.ofNullable(this.backupAdvertIds).orElseGet(HashSet::new);
    }

    public void setBackupAdvertIds(Set<Long> backupAdvertIds) {
        this.backupAdvertIds = backupAdvertIds;
    }

    public Set<MaterialDto> getMaterials() {
        return Optional.ofNullable(this.materials).orElseGet(HashSet::new);
    }

    public void setMaterials(Set<MaterialDto> materials) {
        this.materials = materials;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public Long getLaunchCountToUser() {
        return this.launchCountToUser;
    }

    public void setLaunchCountToUser(Long launchCountToUser) {
        this.launchCountToUser = launchCountToUser;
    }

    public AdvertNewDto() {
    }

    public Long getCurrentCount() {
        long currentCount = Optional.ofNullable(this.launchCountToUser).orElse(0L) + 1L;
        if (currentCount > 10L) {
            currentCount = 10L;
        }
        return currentCount;
    }

    public Long getAdvertId() {
        return this.advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getFee() {
        return this.fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Integer getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Set<String> getSpreadTags() {
        return this.spreadTags;
    }

    public void setSpreadTags(Set<String> spreadTags) {
        this.spreadTags = spreadTags;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getMatchTagNums() {
        return this.matchTagNums;
    }

    public void setMatchTagNums(String matchTagNums) {
        this.matchTagNums = matchTagNums;
    }

    public Map<Long, Set<String>> getMaterialMapNew() {
        return Optional.ofNullable(this.materialMapNew).orElseGet(HashMap::new);
    }

    public void setMaterialMapNew(Map<Long, Set<String>> materialMapNew) {
        this.materialMapNew = materialMapNew;
    }

    public Double getWeight() {
        return this.weight;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public List<Double> getHourlyBudgetFees() {
        return this.hourlyBudgetFees;
    }

    public void setHourlyBudgetFees(List<Double> hourlyBudgetFees) {
        this.hourlyBudgetFees = hourlyBudgetFees;
    }

    public List<Double> getHourlyBudgetCounts() {
        return this.hourlyBudgetCounts;
    }

    public void setHourlyBudgetCounts(List<Double> hourlyBudgetCounts) {
        this.hourlyBudgetCounts = hourlyBudgetCounts;
    }

    public Long getPackageBudget() {
        return this.packageBudget;
    }

    public void setPackageBudget(Long packageBudget) {
        this.packageBudget = packageBudget;
    }

    public Double getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(Double discountRate) {
        this.discountRate = discountRate;
    }

    public String getIndustryTag() {
        return this.industryTag;
    }

    public void setIndustryTag(String industryTag) {
        this.industryTag = industryTag;
    }

    public String getIndustryTagNew() {
        return this.industryTagNew;
    }

    public void setIndustryTagNew(String industryTagNew) {
        this.industryTagNew = industryTagNew;
    }

    public Long getConvertTypeCost() {
        return this.convertTypeCost;
    }

    public void setConvertTypeCost(Long convertTypeCost) {
        this.convertTypeCost = convertTypeCost;
    }

    public Long getConvertCost() {
        return Optional.ofNullable(this.convertTypeCost).orElse(this.convertCost);
    }

    public void setConvertCost(Long convertCost) {
        this.convertCost = convertCost;
    }

    public String getNewTradeTagNum() {
        return this.newTradeTagNum;
    }

    public void setNewTradeTagNum(String newTradeTagNum) {
        this.newTradeTagNum = newTradeTagNum;
    }

    public Integer getCanReplaceLowArpu() {
        return this.canReplaceLowArpu;
    }

    public void setCanReplaceLowArpu(Integer canReplaceLowArpu) {
        this.canReplaceLowArpu = canReplaceLowArpu;
    }

    public Integer getBudgetSmooth() {
        return Optional.ofNullable(this.budgetSmooth).orElse(0);
    }

    public void setBudgetSmooth(Integer budgetSmooth) {
        this.budgetSmooth = budgetSmooth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvertNewDto that = (AdvertNewDto)o;
        return Objects.equals(this.advertId, that.advertId) && Objects.equals(this.packageId, that.packageId);
    }

    public int hashCode() {
        return Objects.hash(this.advertId, this.packageId);
    }

    public static final class Builder {
        private Long advertId;
        private Long packageId;
        private Long fee;
        private Long launchCountToUser;
        private Integer chargeType;
        private Set<String> spreadTags;
        private String accountId;
        private String matchTagNums;
        private Set<MaterialDto> materials;
        private Map<Long, Set<String>> materialMapNew;
        private Double weight;
        private List<Double> hourlyBudgetFees;
        private List<Double> hourlyBudgetCounts;
        private Long packageBudget;
        private Double discountRate;
        private String industryTag;
        private String industryTagNew;
        private Long convertCost;
        private Long convertTypeCost;
        private Set<Long> backupAdvertIds;
        private Boolean supportStatus;
        private Boolean needSupportWeight;
        private Long assessCost;
        private Integer packageType;
        private Integer targetAppLimit;
        private Integer cvrType;
        private Boolean strongTarget;
        private String newTradeTagNum;
        private Integer budgetSmooth;
        private Integer depthCvrType;

        private Builder() {
        }

        public Builder advertId(Long val) {
            this.advertId = val;
            return this;
        }

        public Builder packageId(Long val) {
            this.packageId = val;
            return this;
        }

        public Builder fee(Long val) {
            this.fee = val;
            return this;
        }

        public Builder launchCountToUser(Long val) {
            this.launchCountToUser = val;
            return this;
        }

        public Builder chargeType(Integer val) {
            this.chargeType = val;
            return this;
        }

        public Builder spreadTags(Set<String> val) {
            this.spreadTags = val;
            return this;
        }

        public Builder accountId(String val) {
            this.accountId = val;
            return this;
        }

        public Builder matchTagNums(String val) {
            this.matchTagNums = val;
            return this;
        }

        public Builder materials(Set<MaterialDto> val) {
            this.materials = val;
            return this;
        }

        public Builder materialMapNew(Map<Long, Set<String>> val) {
            this.materialMapNew = val;
            return this;
        }

        public Builder weight(Double val) {
            this.weight = val;
            return this;
        }

        public Builder hourlyBudgetFees(List<Double> val) {
            this.hourlyBudgetFees = val;
            return this;
        }

        public Builder hourlyBudgetCounts(List<Double> val) {
            this.hourlyBudgetCounts = val;
            return this;
        }

        public Builder packageBudget(Long val) {
            this.packageBudget = val;
            return this;
        }

        public Builder discountRate(Double val) {
            this.discountRate = val;
            return this;
        }

        public Builder industryTag(String val) {
            this.industryTag = val;
            return this;
        }

        public Builder industryTagNew(String val) {
            this.industryTagNew = val;
            return this;
        }

        public Builder convertCost(Long val) {
            this.convertCost = val;
            return this;
        }

        public Builder convertTypeCost(Long val) {
            this.convertTypeCost = val;
            return this;
        }

        public Builder backupAdvertIds(Set<Long> val) {
            this.backupAdvertIds = val;
            return this;
        }

        public Builder supportStatus(Boolean val) {
            this.supportStatus = val;
            return this;
        }

        public Builder needSupportWeight(Boolean val) {
            this.needSupportWeight = val;
            return this;
        }

        public Builder assessCost(Long val) {
            this.assessCost = val;
            return this;
        }

        public Builder packageType(Integer val) {
            this.packageType = val;
            return this;
        }

        public Builder targetAppLimit(Integer val) {
            this.targetAppLimit = val;
            return this;
        }

        public Builder cvrType(Integer val) {
            this.cvrType = val;
            return this;
        }

        public Builder depthCvrType(Integer val) {
            this.depthCvrType = val;
            return this;
        }

        public Builder strongTarget(Boolean val) {
            this.strongTarget = val;
            return this;
        }

        public Builder newTradeTagNum(String val) {
            this.newTradeTagNum = val;
            return this;
        }

        public Builder budgetSmooth(Integer val) {
            this.budgetSmooth = val;
            return this;
        }

        public AdvertNewDto build() {
            return new AdvertNewDto(this);
        }
    }
}

