/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum AdvertType {
    SHOW(2, "\u5c55\u793a\u5e7f\u544a", 4),
    INTERACT(1, "\u4e92\u52a8\u5e7f\u544a", -1);

    private Integer value;
    private String desc;
    private Integer mainType;
    private static final Map<Integer, AdvertType> map;

    public static AdvertType of(Integer code) {
        return map.getOrDefault(code, INTERACT);
    }

    private AdvertType(Integer value, String desc, Integer mainType) {
        this.value = value;
        this.desc = desc;
        this.mainType = mainType;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getMainType() {
        return this.mainType;
    }

    static {
        map = Arrays.stream(AdvertType.values()).collect(Collectors.toMap(AdvertType::getValue, v -> v));
    }
}

