package cn.com.duiba.nezha.engine.api.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * Created by lwj on 2016/8/30.
 * 请求广告结果
 */
@Getter
@Setter
public class RcmdAdvertDto implements Serializable {

    private static final long serialVersionUID = -316104112618944933L;

    private Long packageId;

    //订单ID
    private String orderId;

    //广告ID
    private Long advertId;

    //单价
    private Long fee;

    //点击率
    private Double ctr;

    //统计点击率
    private Double statCtr;

    //预估点击率
    private Double preCtr;

    //转换率
    private Double cvr;

    //统计转换率
    private Double statCvr;

    //预估转换率
    private Double preCvr;

    //广告素材ID
    private Long materialId;

    // 流量类型[已经下线，需通知engine删除]
    private Long tag;

    // 原始广告id
    private Long originalAdvertId;

    // 推荐(定向/屏蔽)的媒体
    private Set<RecommendAppDto> recommendApps;

    // 需要熔断的配置包
    private Set<FusingOrientationPackageDto> fusingOrientationPackages;

    private Double supportWeight;
    private Boolean supportSuccess;

    //是否需要特征日志打印:1.否 0.是（下线了。需要通知engine）
    private Integer finalLowArpu;

    // 调价因子
    private Double adjustPriceFactor;

    // 平滑因子
    private Double smoothFactor;

    // 预发券需要返回广告的arpu值
    private Double arpu;

    // 广告权重
    private Double weight;

    //最后用了该<标签>数据的调价因子
    private String applyUserInterestTag;

    // 配置与流量交集的人群标签（下线了。需要通知engine）
    private String hitUserInterestTags;

    /**
     * 出单率，为空则没有  可以用于表示是否开启双出价
     */
    @Deprecated
    private Double outOrderRate;

    /**
     * 是否为拓量广告:0/null-ocpc非拓量配置、 1-ocpc拓量配置；
     */
    private Integer expandAdvert;

    /**
     * 是否为人群拓量广告:0/null-非人群拓量配置、 1-人群拓量配置；
     */
    private Integer peopleExpand;

    /** 是否探索: 0/null-否、 1-是 */
    private Integer adExplore;
    /**
     * 是否开启提价保量模式（0=不开启，1=开启）
     */
    private Integer priceRiseMark;

    // 优化目标
    private Integer cvrType;

    /** 是否召回: 0/null-否、 1-是 */
    private Integer recalled;

    /**
     * 是否是券次序定制广告
     */
    @Deprecated
    private boolean isOrderCustom;

    /**
     * 券次序定制广告过滤掉的配置("广告id-配置id"-排序顺序映射)
     */
    @Deprecated
    private Map<String, Integer> orderCustomFilter;

    /**
     * 券次序定制广告标识：0.无配置或者分流对照组;1.命中定制广告;2.未命中定制广告(释放逻辑)
     */
    @Deprecated
    private Integer orderCustomFlag;

    /**降级类型 0：底价降级 {@link cn.com.duiba.nezha.engine.api.enums.DegreeTypeEnum} */
    private Integer degreeType;

    /**
     * 深度因子
     */
    private Double deepFeeFactor = 1.0d;

    /**
     * 是否是被冷启动替换掉的配置
     */
    private boolean replacedByColdStart;

    /**
     * 是否是因为冷启动被算法重新放到top1的广告配置
     */
    private boolean coldStartAndReRank;

    /**
     * 算法推荐胜出的落地页
     */
    private LandpageRcmdDto winLandpageRcmdDto;
}
