package cn.com.duiba.nezha.engine.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import static java.util.stream.Collectors.toMap;

public enum ShowAdvertAlgEnum implements AdvertAlgEnum {

    SHOW_AND_PC_1(2301, "PC,展示广告");

    private Integer type;

    private String desc;


    ShowAdvertAlgEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<String, ShowAdvertAlgEnum> CACHE = Arrays.stream(ShowAdvertAlgEnum.values())
            .collect(HashMap::new,(m,v)->m.put( v.getType().toString(), v),HashMap::putAll);

    public static AdvertAlgEnum get(String strategyId) {
        return CACHE.get(strategyId);
    }

    public String getDesc() {
        return this.desc;
    }

    @Override
    public Integer getType() {
        return this.type;
    }
    @Override
    public AdvertType getAdvertType() {
        return AdvertType.SHOW;
    }
}
