package cn.com.duiba.nezha.engine.api.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 广告推荐活动参数
 *
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: AdvertActivityDto.java , v 0.1 2017/6/8 下午6:57 ZhouFeng Exp $
 */
@Getter
@Setter
public class AdvertActivityDto implements Serializable {
    private static final long serialVersionUID = -3258192891024908925L;

    /**
     * 运营活动id
     */
    private Long operatingActivityId;

    /**
     * 活动类型(0兑吧普通，1兑吧商业，2推啊商业  ）
     */
    private Integer activityUseType;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动类型
     */
    private Long activityType;

    /**
     * 活动标签
     */
    private String tag;

    /**
     * ADX标识id
     */
    private String adxRid;

    /**
     * 多个活动类型
     */
    private List<Integer> activityTypeExt;

    /**
     * 活动定制场景
     * @see cn.com.duiba.nezha.engine.api.enums.ActivitySceneEnum
     */
    @Deprecated
    private Integer activityScene;
}
