package cn.com.duiba.nezha.engine.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * 拓量过滤类型
 *
 * @author zhangbaiqiang
 * @date 2021/6/22
 */
@Getter
@AllArgsConstructor
public enum ExploreFilterType {

    APP_ORIENT_GROUP(1, "媒体配置组合"),
    CONSUME_EXCEED(2, "配置消耗超阈值"),
    EXPOSURE_EXCEED(3, "配置曝光超阈值")
    ;

    private final Integer type;
    private final String desc;

    /**
     * 超阈值类型转化成过滤类型
     *
     * @param exceedType 超阈值类型 {@link ExceedType}
     * @return 对应的过滤类型
     */
    public static Integer convertFromExceedType(Integer exceedType) {
        if (Objects.equals(exceedType, ExceedType.CONSUME_EXCEED.getType())) {
            return CONSUME_EXCEED.getType();
        } else if (Objects.equals(exceedType, ExceedType.EXPOSURE_EXCEED.getType())) {
            return EXPOSURE_EXCEED.getType();
        }
        return null;
    }
}
