package cn.com.duiba.nezha.engine.api.dto;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * oneId 用户特征数据
 */
@Getter
@Setter
public class OneIdDataDto implements Serializable {
    private static final long serialVersionUID = 1L;

    // OneId用户行为数据
    private String oUIIds;
    private String oUILaunchPV;
    private String oUIClickPv;
    private String oUIEffectPv;
    //广告行业（一级行业/二级行业）- 不同行业上发券数量（历史所有）
    private Map<String, Long> advertMatchTagLaunchPv;
    //广告行业（一级行业/二级行业）- 不同行业上点击数量（历史所有）
    private Map<String, Long> advertMatchTagClickPv;
    //广告行业（一级行业/二级行业）- 不同行业上落地页转化数量（历史所有）
    private Map<String, Long> advertMatchTagEffectPv;

    private Long todayLaunch;   // 用户当日第几个订单序列
    private Long historyLaunch; // 用户全局第几个订单序列
    private Long todayActivityLaunch;   // 用户当日该活动第几个订单序列
    private Long historyActivityLaunch; // 用户全局该活动第几个订单序列
    private String lastLaunchTime;  // 用户全局上次发券时间
    private String lastActivityLaunchTime;  // 该活动下上次发券时间
    private String lastActivityLaunchOrder; // 该活动下上一次发券订单
    private String lastActivityClickOrder; // 该活动下上一次点击订单
    private String lastLaunchOrder; // 上一次发券订单
    private String lastClickOrder;  // 上一次点击订单
    private String lastActivity;    // 用户前一单活动
    private String lastAdvertMatchTag;  // 用户前一单广告二级行业标签

    private Map<String, Long> todayResourceLaunch; // 当天各资源下的发券数
    private Map<String, String> lastResourceLaunchTime; // 各资源上次发券时间
    private Map<String, String> lastResourceLaunchOrder;    // 各资源上一次发券订单
    private Map<String, String> lastResourceClickOrder; // 各资源上一次点击订单
    private Map<String, String> lastResourceEffectOrder;    // 各资源上一次转化订单
    private Map<String, Long> todayResourceClickAdvertCount;    // 用户当日各资源点击广告个数
    private Map<String, Long> todayResourceEffectAdvertCount;   // 用户当日各资源转化广告个数
    private String lastResource;    // 用户上一单资源

    private Set<Integer> advertExposureSet;  // 曝光广告集合

    private Set<Integer> advertClickSet;    // 点击广告集合
    private Set<Integer> accountClickSet;   // 点击广告主集合
    private Set<String> resourceClickSet;   // 点击资源集合
    private Set<Integer> tradeClickSet;     // 点击行业集合

    private Set<Integer> advertEffectSet;   // 转化广告集合
    private Set<Integer> accountEffectSet;  // 转化广告主集合
    private Set<String> resourceEffectSet;  // 转化资源集合
    private Set<Integer> tradeEffectSet;    // 转化行业集合

    private Map<Integer, Long> todayAdvertLaunch;   // 用户当日广告发券次数
    private Map<Integer, Long> todayAdvertClick;    // 用户当日广告点击次数
    private Map<Integer, Long> todayAdvertEffect;   // 用户当日广告转化次数
    private Map<Integer, Long> historyAdvertLaunch; // 用户历史广告发券次数
    private Map<Integer, Long> historyAdvertClick;  // 用户历史该广告点击次数
    private Map<Integer, Long> historyAdvertEffect; // 用户历史该广告转化次数

    private Long requestCnt30d;   // 历史30天请求次数
    private Long exposureCnt30d;  // 历史30天曝光次数
    private Long clickCnt30d;     // 历史30天点击次数
}
