package cn.com.duiba.odps.center.api.remoteservice.hzbank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.hzbank.HzBankBillDiDto;

import java.util.Date;
import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/4/8 17:30
 * @description:
 */
@AdvancedFeignClient
public interface RemoteHzBankBillDiService {

    /**
     * 分页查询
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param lastId 上一次最后一个主键id
     * @param pageSize 分页大小
     * @return
     */
    List<HzBankBillDiDto> listByOffset(Date startTime, Date endTime, Long lastId, Integer pageSize);

    /**
     * 批量插入
     * @param billDtoList
     */
    void batchInsert(List<HzBankBillDiDto> billDtoList);
}
