package cn.com.duiba.odps.center.api.dto.paph;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Description:平安惠普签到数据
 */
@Data
public class PaphSignDo implements Serializable {

    private static final long serialVersionUID = -9027069467917962871L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 签到日期
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date signDate;

    /**
     * 签到活动ID
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 签到用户openID
     */
    private String openId;

    /**
     * 用户签到时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date signTime;

    /**
     * 创建时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date gmtModified;

}
