package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.VipGoodsDailyDataDto;

import java.util.Date;
import java.util.List;

/**
 * 会员商品日统计数据表数据库操作接口
 * @Author: xuwei
 * @Date: 2019/06/27 10:41
 */
@AdvancedFeignClient
public interface RemoteVipGoodsDailyDataService {
    /**
     * 根据appId和日期查询
     * @param appId
     * @param startDate
     * @param endDate
     * @return
     */
    List<VipGoodsDailyDataDto> findByAppIdAndDateRange(Long appId, Date startDate, Date endDate);

    /**
     * 根据appId和日期范围查询
     * @param appId
     * @param startDate
     * @param endDate
     * @return
     */
    int countByAppIdAndDateRange(Long appId, Date startDate, Date endDate);
}