package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.VipGoodsPayOrderDataDto;

import java.util.Date;
import java.util.List;

/**
 * 会员商品支付成功订单数据数据库操作接口
 * @Author: xuwei
 * @Date: 2019/06/27 10:41
 */
@AdvancedFeignClient
public interface RemoteVipGoodsPayOrderDataService {
    /**
     * 根据appId和日期范围查询
     * @param appId
     * @param startDate
     * @param endDate
     * @return
     */
    List<VipGoodsPayOrderDataDto> findByAppIdAndDateRange(Long appId, Date startDate, Date endDate);

    /**
     * 根据订单id列表查询
     * @param orderIds
     * @return
     */
    List<VipGoodsPayOrderDataDto> findByOrderIds(List<Long> orderIds);
}