package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsAppRemainDto;
import cn.com.duiba.odps.center.api.dto.OdpsAppSurveyDataDto;

import java.util.Date;

/**
 * @author JunAngLiu
 * @Title: RemoteAppDataTemplateService
 * @Description: app维度数据
 * @date 2019/3/1514:10
 */
@AdvancedFeignClient
public interface RemoteAppDataTemplateService {

    /**
     * app概况数据
     * @param appId
     * @param startDay
     * @param endDay
     * @param pageNo
     * @param pageSize
     * @return
     */

    Page<OdpsAppSurveyDataDto> queryPageByConditions( Long appId, Date startDay,
                                                     Date endDay, int  pageNo, int pageSize);

    /**
     * 获取 app留存数据
     * @param appId
     * @param startDay
     * @param endDay
     * @param type  1 标识 访问留存，2标识 参与留存
     * @param pageNo
     * @param pageSize
     * @return
     */
    Page<OdpsAppRemainDto>
    queryRemainPageByconditions( Long appId, Date startDay,
                                                       Date endDay, Integer type, int  pageNo, int pageSize);


}
