package cn.com.duiba.odps.center.api.remoteservice.marketing;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.marketing.OdpsFulcreditsActBonusDataDto;
import cn.com.duiba.odps.center.api.dto.marketing.OdpsFulcreditsActDailyStatDto;
import cn.com.duiba.odps.center.api.dto.marketing.OdpsFulcreditsActDataStatisticsDto;
import cn.com.duiba.odps.center.api.dto.marketing.OdpsFulcreditsActOrdersDataDto;
import cn.com.duiba.odps.center.api.param.marketing.FulcreditsPageParam;

import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/7/16 上午11:13
 */
@AdvancedFeignClient
public interface RemoteFulcreditsActDataStatisticsService {

    /**
     * 亚朵满赠活动-订单数据
     * @param param
     * @throws BizException
     * @return
     */
    Page<OdpsFulcreditsActOrdersDataDto> pageOrdersData(FulcreditsPageParam param) throws BizException;

    /**
     * 列表查询-订单数据
     * @param param
     * @return
     * @throws BizException
     */
    List<OdpsFulcreditsActOrdersDataDto> listOrdersData(FulcreditsPageParam param) throws BizException;

    /**
     * 亚朵满赠活动-赠品数据
     * @param param
     * @throws BizException
     * @return
     */
    Page<OdpsFulcreditsActBonusDataDto> pageBonusData(FulcreditsPageParam param) throws BizException;

    /**
     * 列表查询-赠品数据
     * @param param
     * @throws BizException
     * @return
     */
    List<OdpsFulcreditsActBonusDataDto> listBonusData(FulcreditsPageParam param) throws BizException;


    /**
     * 亚朵满赠活动-访问数据
     * @param param
     * @throws BizException
     * @return
     */
    Page<OdpsFulcreditsActDailyStatDto> pageDailyStat(FulcreditsPageParam param) throws BizException;

    /**
     * 列表查询-访问数据
     * @param param
     * @return
     * @throws BizException
     */
    List<OdpsFulcreditsActDailyStatDto> listDailyStat(FulcreditsPageParam param) throws BizException;


    /**
     * 数据概览
     * @param param
     * @return
     * @throws BizException
     */
    OdpsFulcreditsActDataStatisticsDto totalDataStatistics(FulcreditsPageParam param) throws BizException;
}
