package cn.com.duiba.odps.center.api.dto.genie;

import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.List;

/**
 * Created by sunyan on 2019/8/6.
 */
public class ChartDataDto implements Serializable {
    private static final long serialVersionUID = -7711162829069076019L;
    /**
     * 主键
     **/
    private Long id;
    /**
     * 图标名称
     **/
    private String chartName;
    /**
     * 图表类型。1：折线图；2：柱状图；3：饼图；4：核心数据列表；5：热力图；6：数据列表；
     **/
    private Integer chartType;
    /**
     * 维度，取自选定的数据表字段（X轴,列表类型没有,列表放入时间控件字段）
     **/
    private String dimension;
    /**
     * 时间控件状态。0：开启；1：关闭
     **/
    private Boolean timeControlState;
    /**
     * 筛选最大时间间隔（不超过365天）
     **/
    private Integer maxTimeSpan;
    /**
     * 默认展示天数(不超过365天)
     **/
    private Integer defaultTimeSpan;
    /**
     * 展示指标
     */
    private List<JsonTargetListDto> jsonTargetListDtoList;
    /**
     * 图表数据
     */
    private List<JSONObject> chartDataList;
    /**
     * 数据列表条数
     */
    private Integer totalCount;
    /**
     * 指标描述
     **/
    private String targetDescription;
    /**
     * 指标描述开关
     **/
    private Boolean targetDescriptionState;

    /**
     * 维度场景值(只有饼图和数据列表会有)
     **/
    private String dimesionScene;

    public String getDimesionScene() {
        return dimesionScene;
    }

    public void setDimesionScene(String dimesionScene) {
        this.dimesionScene = dimesionScene;
    }

    public String getTargetDescription() {
        return targetDescription;
    }

    public void setTargetDescription(String targetDescription) {
        this.targetDescription = targetDescription;
    }

    public Boolean getTargetDescriptionState() {
        return targetDescriptionState;
    }

    public void setTargetDescriptionState(Boolean targetDescriptionState) {
        this.targetDescriptionState = targetDescriptionState;
    }


    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getChartName() {
        return chartName;
    }

    public void setChartName(String chartName) {
        this.chartName = chartName;
    }

    public Integer getChartType() {
        return chartType;
    }

    public void setChartType(Integer chartType) {
        this.chartType = chartType;
    }

    public String getDimension() {
        return dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public Boolean getTimeControlState() {
        return timeControlState;
    }

    public void setTimeControlState(Boolean timeControlState) {
        this.timeControlState = timeControlState;
    }

    public Integer getMaxTimeSpan() {
        return maxTimeSpan;
    }

    public void setMaxTimeSpan(Integer maxTimeSpan) {
        this.maxTimeSpan = maxTimeSpan;
    }

    public List<JsonTargetListDto> getJsonTargetListDtoList() {
        return jsonTargetListDtoList;
    }

    public void setJsonTargetListDtoList(List<JsonTargetListDto> jsonTargetListDtoList) {
        this.jsonTargetListDtoList = jsonTargetListDtoList;
    }

    public List<JSONObject> getChartDataList() {
        return chartDataList;
    }

    public void setChartDataList(List<JSONObject> chartDataList) {
        this.chartDataList = chartDataList;
    }

    public <T extends ChartDataDto> T cast2Child(){
        try {
            return (T) this;
        }catch (ClassCastException e){
            throw new RuntimeException("类型转换错误");
        }
    }

    public Integer getDefaultTimeSpan() {
        return defaultTimeSpan;
    }

    public void setDefaultTimeSpan(Integer defaultTimeSpan) {
        this.defaultTimeSpan = defaultTimeSpan;
    }
}
