package cn.com.duiba.odps.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.odps.center.api.dto.OdpsActivityIndicatorDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2018/12/18 10:52
 */
@AdvancedFeignClient
public interface RemoteOdpsActivityIndicatorService {

    /**
     * 根据应用和时间查询活动运营数据
     * 不传时间，默认返回最近一个月数据
     *
     * @param appId      应用ID
     * @param day        统计日期 yyyy-MM-dd
     * @param activityId 活动ID
     * @return 活动运营数据
     */
    List<OdpsActivityIndicatorDto> getActivityIndicator(Long appId, String day, Long activityId);

}
