package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 客户经营看板业务枚举
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustBulletinBoardStatisticsTypeEnum {
    WORK_LOAD(1, "工作量"),
    ADVANCE(2, "客户推进结果"),
    INTERVIEW(3, "面访情况统计"),
    ;

    private static final Map<Integer, CustBulletinBoardStatisticsTypeEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustBulletinBoardStatisticsTypeEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustBulletinBoardStatisticsTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustBulletinBoardStatisticsTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
