package cn.com.duiba.oto.oto.service.api.remoteservice.rights;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.rights.CustomerPackageDto;
import cn.com.duiba.oto.dto.oto.rights.CustomerRightsDto;
import cn.com.duiba.oto.dto.oto.rights.CustomerRightsVerifyDto;
import cn.com.duiba.oto.dto.oto.rights.RightsConfigDto;
import cn.com.duiba.oto.dto.oto.rights.RightsPackageConfigDto;
import cn.com.duiba.oto.dto.oto.rights.RightsPackageDto;
import cn.com.duiba.oto.param.oto.rights.RightsConfigDelParam;
import cn.com.duiba.oto.param.oto.rights.RightsPackageSaveParam;
import cn.com.duiba.oto.param.oto.rights.RightsSendParam;
import cn.com.duiba.oto.param.oto.rights.RightsVerifyParam;
import cn.com.duiba.oto.param.oto.rights.SearchCustPackageParam;
import cn.com.duiba.oto.param.oto.rights.SearchRightsConfigParam;
import cn.com.duiba.oto.param.oto.rights.SearchRightsPackageParam;
import cn.com.duiba.oto.param.oto.rights.SearchVerifyListParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * @author xiaotian
 * @Description
 */
@AdvancedFeignClient
public interface RemoteRightsService {

    /**
     * 新增更新权益
     *
     * @param rightsConfigDto
     * @return
     */
    boolean saveRights(RightsConfigDto rightsConfigDto);

    /**
     * 获取权益列表
     *
     * @param searchRightsConfigParam
     * @return
     */
    PageResult<RightsConfigDto> pageRightsConfig(SearchRightsConfigParam searchRightsConfigParam);

    /**
     * 根据权益id，获取权益详情
     *
     * @param rightIds
     * @return
     */
    List<RightsConfigDto> rightsConfigList(List<Long> rightIds);


    /**
     * 根据权益id，获取关联的权益包
     *
     * @param rightIds
     * @return
     */
    List<RightsPackageConfigDto> findPackageByRightsId(List<Long> rightIds);


    /**
     * 根据权益包id，获取权益包详情
     *
     * @param packageIds
     * @return
     */
    List<RightsPackageDto> packageList(List<Long> packageIds);


    /**
     * 获取权益包列表
     *
     * @param searchRightsPackageParam
     * @return
     */
    PageResult<RightsPackageDto> pagePackageList(SearchRightsPackageParam searchRightsPackageParam);

    /**
     * 获取客户权益包列表
     *
     * @param searchCustPackageParam
     * @return
     */
    PageResult<CustomerPackageDto> pageCustPackageList(SearchCustPackageParam searchCustPackageParam);


    /**
     * 获取客户所有权益
     *
     * @param custId
     * @return
     */
    List<CustomerRightsDto> custRights(Long custId);

    /**
     * 获取核销权益记录
     *
     * @param searchVerifyListParam
     * @return
     */
    PageResult<CustomerRightsVerifyDto> pageRightsVerifyList(SearchVerifyListParam searchVerifyListParam);

    /**
     * 核销权益
     *
     * @param rightsVerifyParam
     * @return
     */
    boolean verifyRight(RightsVerifyParam rightsVerifyParam) throws BizException;


    /**
     * 根据产品包id获取所有的配置的权益列表
     *
     * @param packageIds
     * @return
     */
    List<RightsPackageConfigDto> packageRights(List<Long> packageIds);


    /**
     * 新增产品卡
     *
     * @param rightsPackageSaveParam
     * @return
     */
    boolean savePackage(RightsPackageSaveParam rightsPackageSaveParam) throws BizException;

    /**
     * 删除权益
     */
    Boolean delRightsConfig(RightsConfigDelParam param) throws BizException;

    /**
     * 发放权益给客户
     *
     * @param rightsSendParam
     * @return
     */
    boolean sendRights(RightsSendParam rightsSendParam);

    /**
     * 获取客户最近更新的权益包
     *
     * @param custId
     * @return
     */
    Long custLastPackage(Long custId);
}
