package cn.com.duiba.oto.enums.activity;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 社区活动顺序配置枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum ActivityConfigIndexEnum {

    FRIST(1, "活动1"),
    SECOND(2, "活动2"),
    THIRD(3, "活动3"),
    FOURTH(4, "活动4"),
    ;

    private static final Map<Integer, ActivityConfigIndexEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ActivityConfigIndexEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    ActivityConfigIndexEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityConfigIndexEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
