/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ActivityTypeEnum {
    NORMAL(1, "\u5e38\u89c4\u6d3b\u52a8"),
    NEW(2, "\u65b0\u4eba\u6d3b\u52a8");

    private static final Map<Integer, ActivityTypeEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private ActivityTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ActivityTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(ActivityTypeEnum.values()).collect(Collectors.toMap(ActivityTypeEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

