package cn.com.duiba.oto.oto.service.api.remoteservice.wxwork;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.agent.SuiteH5DeptDto;
import cn.com.duiba.oto.dto.oto.agent.SuiteH5DeptMemberDto;

import javax.annotation.Nullable;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-04-11 19:46
 * 企微应用-通讯录-api
 * 使用通讯录管理接口，原则上需要使用 通讯录管理secret，也可以使用 应用secret。
 * 但是使用应用secret只能进行“查询”、“邀请”等非写操作，而且只能操作应用可见范围内的通讯录。
 * 可见范围设置：企微后台-应用管理-可见范围
 */
@AdvancedFeignClient
public interface RemoteCorpAgentH5ContactService {

    /**
     * 获取部门列表
     * @param agentId 自建应用id
     * @param deptId 部门id 如果不填，默认获取全量组织架构
     * @return 部门列表数据
     */
    List<SuiteH5DeptDto> listDept(String agentId, @Nullable Long deptId);

    /**
     * 获取部门成员
     * @param agentId 自建应用id
     * @param deptId 部门id
     * @return 部门列表数据
     */
    List<SuiteH5DeptMemberDto> listDeptMember(String agentId, Long deptId);
}
