package cn.com.duiba.oto.enums.sign;

import java.util.stream.Stream;

/**
 * 功能描述：签到任务状态
 *
 * @Auther: xiaotian
 * @Date: 2023/11/20 17:55
 * @Description:
 */
public enum SignTaskStatusEnum {

    /**
     * 签到中
     */
    DOING(0, "签到中"),
    /**
     * 已领取奖励
     */
    FINISH(1, "领取奖励"),
    /**
     * 已核销奖励
     */
    VERTFY(2, "核销奖励");

    private Integer status;

    private String desc;

    SignTaskStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public static SignTaskStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return Stream.of(SignTaskStatusEnum.values()).filter(rightTypeEnum -> rightTypeEnum.getStatus().equals(status)).findFirst().orElse(null);
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }
}
