package cn.com.duiba.oto.enums.rights;

import java.util.stream.Stream;

/**
 * 功能描述：状态类型
 *
 * @Auther: xiaotian
 * @Date: 2023/11/20 17:55
 * @Description:
 */
public enum RightStatusEnum {

    CLOSE(0, "禁用"),
    OPEN(1, "启用");

    private Integer type;

    private String desc;

    RightStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static RightStatusEnum getByType(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(RightStatusEnum.values()).filter(rightTypeEnum -> rightTypeEnum.getType().equals(code)).findFirst().orElse(null);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
