package cn.com.duiba.oto.param.oto.sign;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：签到任务筛选参数
 *
 * @Auther: xiaotian
 * @Date: 2024/8/19 13:55
 * @Description:
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SignRecordQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 1556206252260080596L;

    /**
     * 搜索参数（客户姓名、客户id、用户昵称）
     */
    private String params;
    /**
     * 奖品id
     */
    private List<Long> prizeIds;
    /**
     * 任务状态 0:未完成 1:已完成 2:已核销
     *
     * @see cn.com.duiba.oto.enums.sign.SignTaskStatusEnum
     */
    private Integer taskStatus;
    /**
     * 专家列表
     */
    private List<Long> sellerIds;
}
