package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.OtoSellerThirdPartyDto;
import cn.com.duiba.oto.param.oto.call.CallPhoneDto;
import cn.com.duiba.oto.param.oto.call.YunkeCallbackParam;
import cn.com.duiba.oto.param.oto.call.YunkeLocationRecordParam;

import java.util.List;

/**
 * OTO-成员第三方信息服务
 *
 * @author xiaotian
 * @date 2022/9/19 5:59 下午
 */
@AdvancedFeignClient
public interface RemoteOtoSellerThirdPartyService {

    /**
     * 获取销售账号信息
     *
     * @param sellerIds
     * @param thirdTypeType
     * @return
     */
    List<OtoSellerThirdPartyDto> selectBySellerIdsAndThirdParty(List<Long> sellerIds, Integer thirdTypeType);


    /**
     * 销售分配新账号（云客）
     *
     * @param accountName 销售账号参数
     * @return 是否成功
     */
    boolean assignYunkeAccount(Long sellerId, String accountName);

    /**
     * 根据销售id删除三方账号（云客）
     *
     * @param sellerId 销售id
     * @return 删除结果
     */
    boolean removeYunkeAccountBySid(Long sellerId);

    /**
     * 获取所有可用的账号
     *
     * @return 所有可用的账号
     */
    List<String> listAvailableImeis();

    /**
     * 用户与云客手机设备绑定查询和同步本地库
     *
     * @return
     */
    boolean syncBindings(Long sellerId) throws BizException;

    /**
     * 用户与云客手机设备绑定查询和同步本地库（全量）
     *
     * @return
     */
    boolean syncAllBindings() throws BizException;

    /**
     * 云客回传通话记录
     *
     * @param yunkeCallbackParams
     * @return
     */
    boolean syncYunkeCallRecord(List<YunkeCallbackParam> yunkeCallbackParams);


    /**
     * 云客回传定位记录
     *
     * @param records
     * @return
     */
    void syncYunkeLocationRecord(List<YunkeLocationRecordParam> records) throws BizException;

    /**
     * 获取设备插拔卡状态
     *
     * @return
     */
    List<CallPhoneDto> simstatusRecords(String userName, String imei) throws BizException;


    /**
     * 云客微信语音同步接口
     *
     * @return
     */
    void syncYunkeWxVoice() throws BizException;

}
