package cn.com.duiba.oto.enums.activity;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物业二维码活动映射关系
 *
 * @Author xiaotian
 * @Date 2025/6/11 19:53
 * @Version 1.0
 */
@AllArgsConstructor
@Getter
public enum WuyeActivityIndexEnum {
    FIRST(1, "学校活动"), SECOND(2, "牙齿活动"), THIRD(3, "牙齿活动"), FOURTH(4, "学校活动"), FIFTH(5, "学校活动"), SIXTH(6, "牙齿活动"), SEVENTH(7, "学校活动"), EIGHTH(8, "牙齿活动"), NINTH(9, "学校活动"), TENTH(10, "牙齿活动"), ELEVENTH(301, "眼科活动"), TWELFTH(302, "眼科活动"), THIRTEENTH(303, "眼科活动"), FOURTEENTH(304, "眼科活动"), FIFTEENTH(305, "眼科活动"),
    ;


    private static final Map<Integer, WuyeActivityIndexEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(WuyeActivityIndexEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    /**
     * 编码
     */
    private final Integer code;
    /**
     * 备注
     */
    private final String desc;
    ;

    public static WuyeActivityIndexEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
