package cn.com.duiba.oto.dto.oto.wx.qrcode;

import cn.com.duiba.oto.dto.response.WechatBaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author xiaotian
 * @date 2020/11/16 2:20 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
public class OaQrcodeResultDto extends WechatBaseResponseDto {

    private static final long serialVersionUID = -7255279798522447343L;

    /**
     * 获取的二维码ticket，凭借此ticket可以在有效时间内换取二维码。
     * 在用户扫码回调时会传递回来
     */
    private String ticket;

    /**
     * 该二维码有效时间，以秒为单位。 最大不超过2592000（即30天）
     * 临时类型二维码有效
     */
    private Long expireSeconds;

    /**
     * 二维码地址
     */
    private String url;
}
