package cn.com.duiba.oto.enums.activity;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 转介绍活动状态枚举
 *
 * @author xiaotian
 * @Description
 */
@Getter
public enum InviteActivityFlowEnum {

    INIT(0, "初始化"),
    SUBMIT(1, "客户提交"),
    NOT_ORDER_COMPLETE(2, "客户未下单到场"),
    ORDER(3, "客户下单"),
    COMPLETE(4, "客户到场");

    private static final Map<Integer, InviteActivityFlowEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(InviteActivityFlowEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    ;


    private final Integer code;
    private final String desc;

    InviteActivityFlowEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static InviteActivityFlowEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
