package cn.com.duiba.oto.enums.seller.task;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author xiaotian
 * @date 2022/11/04 15:53
 */
@Getter
@AllArgsConstructor
public enum RejectResonEnum {
    LOCATION_NOT_FIT(1, "位置不合适"),
    NO_NEED(2, "无养老需求"),
    NO_POWER(3, "无经济能力"),
    ;

    private Integer code;
    private String desc;

    private static final Map<Integer, String> TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(RejectResonEnum::getCode, RejectResonEnum::getDesc, (v1, v2) -> v1)));


    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static RejectResonEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(RejectResonEnum.values()).filter(rejectResonEnum -> rejectResonEnum.getCode().equals(code)).findFirst().orElse(null);
    }
}
